package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkey;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem
 *
 */
public class MappingAuthkeyItemBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem> {

    private MappingAuthkeyItemKey _key;
    private MappingAuthkey _mappingAuthkey;
    private java.lang.String _mappingAuthkeyItemId;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>> augmentation = Collections.emptyMap();

    public MappingAuthkeyItemBuilder() {
    }
    public MappingAuthkeyItemBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer arg) {
        this._mappingAuthkey = arg.getMappingAuthkey();
    }

    public MappingAuthkeyItemBuilder(MappingAuthkeyItem base) {
        if (base.getKey() == null) {
            this._key = new MappingAuthkeyItemKey(
                base.getMappingAuthkeyItemId()
            );
            this._mappingAuthkeyItemId = base.getMappingAuthkeyItemId();
        } else {
            this._key = base.getKey();
            this._mappingAuthkeyItemId = _key.getMappingAuthkeyItemId();
        }
        this._mappingAuthkey = base.getMappingAuthkey();
        if (base instanceof MappingAuthkeyItemImpl) {
            MappingAuthkeyItemImpl impl = (MappingAuthkeyItemImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer) {
            this._mappingAuthkey = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer)arg).getMappingAuthkey();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer] \n" +
              "but was: " + arg
            );
        }
    }

    public MappingAuthkeyItemKey getKey() {
        return _key;
    }
    
    public MappingAuthkey getMappingAuthkey() {
        return _mappingAuthkey;
    }
    
    public java.lang.String getMappingAuthkeyItemId() {
        return _mappingAuthkeyItemId;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public MappingAuthkeyItemBuilder setKey(final MappingAuthkeyItemKey value) {
        this._key = value;
        return this;
    }
    
     
    public MappingAuthkeyItemBuilder setMappingAuthkey(final MappingAuthkey value) {
        this._mappingAuthkey = value;
        return this;
    }
    
     
    public MappingAuthkeyItemBuilder setMappingAuthkeyItemId(final java.lang.String value) {
        this._mappingAuthkeyItemId = value;
        return this;
    }
    
    public MappingAuthkeyItemBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public MappingAuthkeyItemBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public MappingAuthkeyItem build() {
        return new MappingAuthkeyItemImpl(this);
    }

    private static final class MappingAuthkeyItemImpl implements MappingAuthkeyItem {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem.class;
        }

        private final MappingAuthkeyItemKey _key;
        private final MappingAuthkey _mappingAuthkey;
        private final java.lang.String _mappingAuthkeyItemId;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>> augmentation = Collections.emptyMap();

        private MappingAuthkeyItemImpl(MappingAuthkeyItemBuilder base) {
            if (base.getKey() == null) {
                this._key = new MappingAuthkeyItemKey(
                    base.getMappingAuthkeyItemId()
                );
                this._mappingAuthkeyItemId = base.getMappingAuthkeyItemId();
            } else {
                this._key = base.getKey();
                this._mappingAuthkeyItemId = _key.getMappingAuthkeyItemId();
            }
            this._mappingAuthkey = base.getMappingAuthkey();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public MappingAuthkeyItemKey getKey() {
            return _key;
        }
        
        @Override
        public MappingAuthkey getMappingAuthkey() {
            return _mappingAuthkey;
        }
        
        @Override
        public java.lang.String getMappingAuthkeyItemId() {
            return _mappingAuthkeyItemId;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_key);
            result = prime * result + Objects.hashCode(_mappingAuthkey);
            result = prime * result + Objects.hashCode(_mappingAuthkeyItemId);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem other = (org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem)obj;
            if (!Objects.equals(_key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(_mappingAuthkey, other.getMappingAuthkey())) {
                return false;
            }
            if (!Objects.equals(_mappingAuthkeyItemId, other.getMappingAuthkeyItemId())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                MappingAuthkeyItemImpl otherImpl = (MappingAuthkeyItemImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "MappingAuthkeyItem [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_key != null) {
                builder.append("_key=");
                builder.append(_key);
                builder.append(", ");
            }
            if (_mappingAuthkey != null) {
                builder.append("_mappingAuthkey=");
                builder.append(_mappingAuthkey);
                builder.append(", ");
            }
            if (_mappingAuthkeyItemId != null) {
                builder.append("_mappingAuthkeyItemId=");
                builder.append(_mappingAuthkeyItemId);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
