package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * container last-updated {
 *     leaf last-updated {
 *         type int64;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/mapping-database/last-updated</i>
 *
 * <p>To create instances of this class use {@link LastUpdatedBuilder}.
 * @see LastUpdatedBuilder
 *
 */
public interface LastUpdated
    extends
    ChildOf<MappingDatabase>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.LastUpdated>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:lfm:mappingservice",
        "2015-09-06", "last-updated").intern();

    /**
     * Last database update timestamp (in milliseconds since January 1, 1970, 00:00:00 
     * GMT)
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>lastUpdated</code>, or <code>null</code> if not present
     */
    java.lang.Long getLastUpdated();

}

