package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.VniUri;
import java.util.Objects;

public class VirtualNetworkIdentifierKey
 implements Identifier<VirtualNetworkIdentifier> {
    private static final long serialVersionUID = -3933872609824293399L;
    private final VniUri _vni;


    public VirtualNetworkIdentifierKey(VniUri _vni) {
    
    
        this._vni = _vni;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public VirtualNetworkIdentifierKey(VirtualNetworkIdentifierKey source) {
        this._vni = source._vni;
    }


    public VniUri getVni() {
        return _vni;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_vni);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        VirtualNetworkIdentifierKey other = (VirtualNetworkIdentifierKey) obj;
        if (!Objects.equals(_vni, other._vni)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifierKey.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_vni != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_vni=");
            builder.append(_vni);
        }
        return builder.append(']').toString();
    }
}

