/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.clusterdao;

import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.lispflowmapping.interfaces.dao.ILispDAO;
import org.opendaylight.lispflowmapping.interfaces.dao.IRowVisitor;
import org.opendaylight.lispflowmapping.interfaces.dao.MappingEntry;
import org.opendaylight.lispflowmapping.interfaces.dao.MappingServiceRLOCGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterDAOService
implements ILispDAO {
    protected static final Logger logger = LoggerFactory.getLogger(ClusterDAOService.class);
    private IClusterContainerServices clusterContainerService = null;
    private ConcurrentMap<Object, ConcurrentMap<String, Object>> data;
    private final String CACHE_NAME = "mappingServiceCache";
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private int recordTimeOut = 240;
    private int cleanInterval = 10;
    private ScheduledExecutorService scheduler;

    void setClusterContainerService(IClusterContainerServices s) {
        this.clusterContainerService = s;
        this.allocateCache();
        this.retrieveCache();
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ClusterDAOService.this.cleanOld();
            }
        }, 0L, this.cleanInterval, this.timeUnit);
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        logger.trace("Cluster Service unset");
        if (this.clusterContainerService == s) {
            this.clusterContainerService = null;
        }
        this.scheduler.shutdownNow();
    }

    private void allocateCache() {
        if (this.clusterContainerService == null) {
            logger.warn("un-initialized clusterContainerService, can't create cache");
            return;
        }
        logger.trace("Creating Cache for ClusterDAOService");
        try {
            this.clusterContainerService.createCache("mappingServiceCache", EnumSet.of(IClusterServices.cacheMode.NON_TRANSACTIONAL));
        }
        catch (CacheConfigException cce) {
            logger.warn("Cache couldn't be created for ClusterDAOService -  check cache mode");
        }
        catch (CacheExistException cce) {
            logger.warn("Cache for ClusterDAOService already exists, destroy and recreate");
        }
        logger.trace("Cache successfully created for ClusterDAOService");
    }

    private void retrieveCache() {
        if (this.clusterContainerService == null) {
            logger.warn("un-initialized clusterContainerService, can't retrieve cache");
            return;
        }
        logger.trace("Retrieving cache for ClusterDAOService");
        this.data = this.clusterContainerService.getCache("mappingServiceCache");
        if (this.data == null) {
            logger.warn("Cache couldn't be retrieved for ClusterDAOService");
        }
        logger.trace("Cache was successfully retrieved for ClusterDAOService");
    }

    public void getAll(IRowVisitor visitor) {
        for (Map.Entry keyEntry : this.data.entrySet()) {
            for (Map.Entry valueEntry : ((ConcurrentMap)keyEntry.getValue()).entrySet()) {
                visitor.visitRow(keyEntry.getKey(), (String)valueEntry.getKey(), valueEntry.getValue());
            }
        }
    }

    public void put(Object key, MappingEntry<?> ... values) {
        if (!this.data.containsKey(key)) {
            this.data.put(key, new ConcurrentHashMap());
        }
        for (MappingEntry<?> entry : values) {
            ((ConcurrentMap)this.data.get(key)).put(entry.getKey(), entry.getValue());
        }
    }

    public void cleanOld() {
        this.getAll(new IRowVisitor(){

            public void visitRow(Object keyId, String valueKey, Object value) {
                MappingServiceRLOCGroup rloc;
                if (value instanceof MappingServiceRLOCGroup && this.isExpired(rloc = (MappingServiceRLOCGroup)value)) {
                    ClusterDAOService.this.removeSpecific(keyId, valueKey);
                }
            }

            private boolean isExpired(MappingServiceRLOCGroup rloc) {
                return System.currentTimeMillis() - rloc.getRegisterdDate().getTime() > TimeUnit.MILLISECONDS.convert(ClusterDAOService.this.recordTimeOut, ClusterDAOService.this.timeUnit);
            }
        });
    }

    public Object getSpecific(Object key, String valueKey) {
        Map keyToValues = (Map)this.data.get(key);
        if (keyToValues == null) {
            return null;
        }
        return keyToValues.get(valueKey);
    }

    public Map<String, Object> get(Object key) {
        return (Map)this.data.get(key);
    }

    public void remove(Object key) {
        this.data.remove(key);
    }

    public void removeSpecific(Object key, String valueKey) {
        if (this.data.containsKey(key) && ((ConcurrentMap)this.data.get(key)).containsKey(valueKey)) {
            ((ConcurrentMap)this.data.get(key)).remove(valueKey);
        }
    }

    public void removeAll() {
        this.data.clear();
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setRecordTimeOut(int recordTimeOut) {
        this.recordTimeOut = recordTimeOut;
    }

    public int getRecordTimeOut() {
        return this.recordTimeOut;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }
}

