package org.opendaylight.yang.gen.v1.lispconfig.rev131107 ;

import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import java.util.Set;
import java.util.HashSet;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.io.IOException;


public final class $YangModuleInfoImpl implements YangModuleInfo {

    private static final YangModuleInfo INSTANCE = new $YangModuleInfoImpl();

    private final Set<YangModuleInfo> importedModules;

    public static YangModuleInfo getInstance() {
        return INSTANCE;
    }

    private $YangModuleInfoImpl() {
        Set<YangModuleInfo> set = new HashSet<>();
        set.add(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.$YangModuleInfoImpl.getInstance());
        set.add(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.rpc.context.rev130617.$YangModuleInfoImpl.getInstance());
        importedModules = ImmutableSet.copyOf(set);
    
        InputStream stream = $YangModuleInfoImpl.class.getResourceAsStream("META-INF/yang/config-lisp.yang");
        if (stream == null) {
            throw new IllegalStateException("Resource META-INF/yang/config-lisp.yang is missing");
        }
        try {
            stream.close();
        } catch (IOException e) {
            // Resource leak, but there is nothing we can do
        }
    }
    
    @Override
    public String getName() {
        return "config-lisp";
    }
    
    @Override
    public String getRevision() {
        return "2013-11-07";
    }
    
    @Override
    public String getNamespace() {
        return "lispconfig";
    }
    
    @Override
    public InputStream getModuleSourceStream() throws IOException {
        InputStream stream = $YangModuleInfoImpl.class.getResourceAsStream("META-INF/yang/config-lisp.yang");
        if (stream == null) {
            throw new IOException("Resource META-INF/yang/config-lisp.yang is missing");
        }
        return stream;
    }
    
    @Override
    public Set<YangModuleInfo> getImportedModules() {
        return importedModules;
    }
}
