package org.opendaylight.yang.gen.v1.lispconfig.rev131107.modules.module.configuration;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import java.util.HashMap;



public class LispconfigBuilder {

    private String _bindAddress;
    private Map<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.lispconfig.rev131107.modules.module.configuration.Lispconfig>>, Augmentation<org.opendaylight.yang.gen.v1.lispconfig.rev131107.modules.module.configuration.Lispconfig>> augmentation = new HashMap<>();

    public LispconfigBuilder() {
    } 
    


    public String getBindAddress() {
        return _bindAddress;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.lispconfig.rev131107.modules.module.configuration.Lispconfig>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public LispconfigBuilder setBindAddress(String value) {
    
        this._bindAddress = value;
        return this;
    }
    
    public LispconfigBuilder addAugmentation(Class<? extends Augmentation<org.opendaylight.yang.gen.v1.lispconfig.rev131107.modules.module.configuration.Lispconfig>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.lispconfig.rev131107.modules.module.configuration.Lispconfig> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Lispconfig build() {
        return new LispconfigImpl(this);
    }

    private static final class LispconfigImpl implements Lispconfig {

        public Class<org.opendaylight.yang.gen.v1.lispconfig.rev131107.modules.module.configuration.Lispconfig> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.lispconfig.rev131107.modules.module.configuration.Lispconfig.class;
        }

        private final String _bindAddress;
        private Map<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.lispconfig.rev131107.modules.module.configuration.Lispconfig>>, Augmentation<org.opendaylight.yang.gen.v1.lispconfig.rev131107.modules.module.configuration.Lispconfig>> augmentation = new HashMap<>();

        private LispconfigImpl(LispconfigBuilder builder) {
            this._bindAddress = builder.getBindAddress();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public String getBindAddress() {
            return _bindAddress;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.lispconfig.rev131107.modules.module.configuration.Lispconfig>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_bindAddress == null) ? 0 : _bindAddress.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (getClass() != obj.getClass()) {
                return false;
            }
            LispconfigImpl other = (LispconfigImpl) obj;
            if (_bindAddress == null) {
                if (other._bindAddress != null) {
                    return false;
                }
            } else if(!_bindAddress.equals(other._bindAddress)) {
                return false;
            }
            if (augmentation == null) {
                if (other.augmentation != null) {
                    return false;
                }
            } else if(!augmentation.equals(other.augmentation)) {
                return false;
            }
            return true;
        }
        
        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Lispconfig [_bindAddress=");
            builder.append(_bindAddress);
            builder.append(", augmentation=");
            builder.append(augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }

}
