/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.dsbackend;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.md.sal.binding.api.BindingTransactionChain;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChain;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.lispflowmapping.dsbackend.InstanceIdentifierUtil;
import org.opendaylight.lispflowmapping.lisp.util.LispAddressStringifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.LispAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.XtrId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreBackEnd
implements TransactionChainListener {
    protected static final Logger LOG = LoggerFactory.getLogger(DataStoreBackEnd.class);
    private static final InstanceIdentifier<MappingDatabase> DATABASE_ROOT = InstanceIdentifier.create(MappingDatabase.class);
    private BindingTransactionChain txChain;

    public DataStoreBackEnd(DataBroker broker) {
        this.txChain = broker.createTransactionChain((TransactionChainListener)this);
    }

    public void addAuthenticationKey(AuthenticationKey authenticationKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD-SAL: Adding authentication key '{}' for {}", (Object)authenticationKey.getMappingAuthkey().getKeyString(), (Object)LispAddressStringifier.getString((LispAddress)authenticationKey.getEid()));
        }
        InstanceIdentifier<AuthenticationKey> path = InstanceIdentifierUtil.createAuthenticationKeyIid(authenticationKey.getEid());
        this.writePutTransaction(path, authenticationKey, LogicalDatastoreType.CONFIGURATION, "Adding authentication key to MD-SAL datastore failed");
    }

    public void addMapping(Mapping mapping) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD-SAL: Adding mapping for {}", (Object)LispAddressStringifier.getString((LispAddress)mapping.getMappingRecord().getEid()));
        }
        InstanceIdentifier<Mapping> path = InstanceIdentifierUtil.createMappingIid(mapping.getMappingRecord().getEid(), mapping.getOrigin());
        this.writePutTransaction(path, mapping, DataStoreBackEnd.getDestinationDatastore(mapping), "Adding mapping to MD-SAL datastore failed");
    }

    public void addXtrIdMapping(XtrIdMapping mapping) {
        XtrId xtrId = mapping.getMappingRecord().getXtrId();
        Preconditions.checkNotNull((Object)xtrId, (Object)"Make sure you only call addXtrIdMapping when the MappingRecord contains an xTR-ID");
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD-SAL: Adding mapping for {}, xTR-ID {}", (Object)LispAddressStringifier.getString((LispAddress)mapping.getMappingRecord().getEid()), (Object)xtrId);
        }
        InstanceIdentifier<XtrIdMapping> path = InstanceIdentifierUtil.createXtrIdMappingIid(mapping.getMappingRecord().getEid(), MappingOrigin.Southbound, xtrId);
        this.writePutTransaction(path, mapping, LogicalDatastoreType.OPERATIONAL, "Adding xTR-ID mapping to MD-SAL datastore failed");
    }

    public void removeAuthenticationKey(AuthenticationKey authenticationKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD-SAL: Removing authentication key for {}", (Object)LispAddressStringifier.getString((LispAddress)authenticationKey.getEid()));
        }
        InstanceIdentifier<AuthenticationKey> path = InstanceIdentifierUtil.createAuthenticationKeyIid(authenticationKey.getEid());
        this.deleteTransaction(path, LogicalDatastoreType.CONFIGURATION, "Deleting authentication key from MD-SAL datastore failed");
    }

    public void removeMapping(Mapping mapping) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD-SAL: Removing mapping for {}", (Object)LispAddressStringifier.getString((LispAddress)mapping.getMappingRecord().getEid()));
        }
        InstanceIdentifier<Mapping> path = InstanceIdentifierUtil.createMappingIid(mapping.getMappingRecord().getEid(), mapping.getOrigin());
        this.deleteTransaction(path, DataStoreBackEnd.getDestinationDatastore(mapping), "Deleting mapping from MD-SAL datastore failed");
    }

    public void removeXtrIdMapping(XtrIdMapping mapping) {
        XtrId xtrId = mapping.getMappingRecord().getXtrId();
        Preconditions.checkNotNull((Object)xtrId, (Object)"Make sure you only call addXtrIdMapping when the MappingRecord contains an xTR-ID");
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD-SAL: Removing mapping for {}, xTR-ID {}", (Object)LispAddressStringifier.getString((LispAddress)mapping.getMappingRecord().getEid()), (Object)xtrId);
        }
        InstanceIdentifier<XtrIdMapping> path = InstanceIdentifierUtil.createXtrIdMappingIid(mapping.getMappingRecord().getEid(), MappingOrigin.Southbound, xtrId);
        this.deleteTransaction(path, LogicalDatastoreType.OPERATIONAL, "Deleting xTR-ID mapping from MD-SAL datastore failed");
    }

    public void removeAllDatastoreContent() {
        LOG.debug("MD-SAL: Removing all mapping database datastore content (mappings and keys)");
        this.removeAllConfigDatastoreContent();
        this.removeAllOperationalDatastoreContent();
    }

    public void removeAllConfigDatastoreContent() {
        this.deleteTransaction(DATABASE_ROOT, LogicalDatastoreType.CONFIGURATION, "Removal of all database content in config datastore failed");
    }

    public void removeAllOperationalDatastoreContent() {
        this.deleteTransaction(DATABASE_ROOT, LogicalDatastoreType.OPERATIONAL, "Removal of all database content in operational datastore failed");
    }

    public void updateAuthenticationKey(AuthenticationKey authenticationKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD-SAL: Updating authentication key for {} with '{}'", (Object)LispAddressStringifier.getString((LispAddress)authenticationKey.getEid()), (Object)authenticationKey.getMappingAuthkey().getKeyString());
        }
        InstanceIdentifier<AuthenticationKey> path = InstanceIdentifierUtil.createAuthenticationKeyIid(authenticationKey.getEid());
        this.writePutTransaction(path, authenticationKey, LogicalDatastoreType.CONFIGURATION, "Updating authentication key in MD-SAL datastore failed");
    }

    public void updateMapping(Mapping mapping) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD-SAL: Updating mapping for {}", (Object)LispAddressStringifier.getString((LispAddress)mapping.getMappingRecord().getEid()));
        }
        InstanceIdentifier<Mapping> path = InstanceIdentifierUtil.createMappingIid(mapping.getMappingRecord().getEid(), mapping.getOrigin());
        this.writePutTransaction(path, mapping, DataStoreBackEnd.getDestinationDatastore(mapping), "Updating mapping in MD-SAL datastore failed");
    }

    public List<Mapping> getAllMappings() {
        List<Mapping> mappings = this.getAllMappings(LogicalDatastoreType.CONFIGURATION);
        mappings.addAll(this.getAllMappings(LogicalDatastoreType.OPERATIONAL));
        return mappings;
    }

    public List<Mapping> getAllMappings(LogicalDatastoreType logicalDataStore) {
        LOG.debug("MD-SAL: Get all mappings from datastore");
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        MappingDatabase mdb = this.readTransaction(DATABASE_ROOT, logicalDataStore);
        if (mdb != null) {
            for (VirtualNetworkIdentifier id : mdb.getVirtualNetworkIdentifier()) {
                List ms = id.getMapping();
                if (ms == null) continue;
                mappings.addAll(ms);
            }
        }
        return mappings;
    }

    public List<AuthenticationKey> getAllAuthenticationKeys() {
        LOG.debug("MD-SAL: Get all authentication keys from datastore");
        ArrayList<AuthenticationKey> authKeys = new ArrayList<AuthenticationKey>();
        MappingDatabase mdb = this.readTransaction(DATABASE_ROOT, LogicalDatastoreType.CONFIGURATION);
        if (mdb != null) {
            for (VirtualNetworkIdentifier id : mdb.getVirtualNetworkIdentifier()) {
                List keys = id.getAuthenticationKey();
                if (keys == null) continue;
                authKeys.addAll(keys);
            }
        }
        return authKeys;
    }

    private static LogicalDatastoreType getDestinationDatastore(Mapping mapping) {
        return mapping.getOrigin().equals((Object)MappingOrigin.Southbound) ? LogicalDatastoreType.OPERATIONAL : LogicalDatastoreType.CONFIGURATION;
    }

    private <U extends DataObject> void writePutTransaction(InstanceIdentifier<U> addIID, U data, LogicalDatastoreType logicalDatastoreType, String errMsg) {
        WriteTransaction writeTx = this.txChain.newWriteOnlyTransaction();
        writeTx.put(logicalDatastoreType, addIID, data, true);
        Futures.addCallback((ListenableFuture)writeTx.submit(), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
            }

            public void onFailure(Throwable throwable) {
                LOG.error("Transaction failed:", throwable);
            }
        });
    }

    private <U extends DataObject> U readTransaction(InstanceIdentifier<U> readIID, LogicalDatastoreType logicalDatastoreType) {
        ReadOnlyTransaction readTx = this.txChain.newReadOnlyTransaction();
        CheckedFuture readFuture = readTx.read(logicalDatastoreType, readIID);
        readTx.close();
        try {
            Optional optionalDataObject = (Optional)readFuture.checkedGet();
            if (optionalDataObject != null && optionalDataObject.isPresent()) {
                return (U)((DataObject)optionalDataObject.get());
            }
            LOG.debug("{}: Failed to read", (Object)Thread.currentThread().getStackTrace()[1]);
        }
        catch (ReadFailedException e) {
            LOG.warn("Failed to ....", (Throwable)e);
        }
        return null;
    }

    private <U extends DataObject> void deleteTransaction(InstanceIdentifier<U> deleteIID, LogicalDatastoreType logicalDatastoreType, String errMsg) {
        WriteTransaction writeTx = this.txChain.newWriteOnlyTransaction();
        writeTx.delete(logicalDatastoreType, deleteIID);
        Futures.addCallback((ListenableFuture)writeTx.submit(), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
            }

            public void onFailure(Throwable throwable) {
                LOG.error("Transaction failed:", throwable);
            }
        });
    }

    public void onTransactionChainFailed(TransactionChain<?, ?> chain, AsyncTransaction<?, ?> transaction, Throwable cause) {
        LOG.error("Broken chain {} in DataStoreBackEnd, transaction {}, cause {}", new Object[]{chain, transaction.getIdentifier(), cause});
    }

    public void onTransactionChainSuccessful(TransactionChain<?, ?> chain) {
        LOG.info("DataStoreBackEnd closed successfully, chain {}", chain);
    }
}

