/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.dsbackend;

import com.google.common.base.Preconditions;
import org.opendaylight.lispflowmapping.lisp.util.LispAddressStringifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.LispAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.InstanceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.XtrId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.VniUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.XtrIdUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKeyKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.MappingKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMappingKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifierKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class InstanceIdentifierUtil {
    private InstanceIdentifierUtil() {
    }

    public static InstanceIdentifier<AuthenticationKey> createAuthenticationKeyIid(Eid eid) {
        Preconditions.checkNotNull((Object)eid, (Object)"Key needs and EID entry!");
        VirtualNetworkIdentifierKey vniKey = new VirtualNetworkIdentifierKey(new VniUri(Long.toString(InstanceIdentifierUtil.getLispInstanceId(eid))));
        AuthenticationKeyKey authKeyKey = new AuthenticationKeyKey(new EidUri(LispAddressStringifier.getURIString((LispAddress)eid)));
        return InstanceIdentifier.create(MappingDatabase.class).child(VirtualNetworkIdentifier.class, (Identifier)vniKey).child(AuthenticationKey.class, (Identifier)authKeyKey);
    }

    public static InstanceIdentifier<Mapping> createMappingIid(Eid eid, MappingOrigin orig) {
        Preconditions.checkNotNull((Object)eid, (Object)"Mapping needs an EID entry!");
        VirtualNetworkIdentifierKey vniKey = new VirtualNetworkIdentifierKey(new VniUri(Long.toString(InstanceIdentifierUtil.getLispInstanceId(eid))));
        MappingKey eidKey = new MappingKey(new EidUri(LispAddressStringifier.getURIString((LispAddress)eid)), orig);
        return InstanceIdentifier.create(MappingDatabase.class).child(VirtualNetworkIdentifier.class, (Identifier)vniKey).child(Mapping.class, (Identifier)eidKey);
    }

    public static InstanceIdentifier<XtrIdMapping> createXtrIdMappingIid(Eid eid, MappingOrigin orig, XtrId xtrId) {
        Preconditions.checkNotNull((Object)eid, (Object)"Mapping needs an EID entry!");
        Preconditions.checkNotNull((Object)xtrId, (Object)"Mapping needs an xTR-ID entry!");
        VirtualNetworkIdentifierKey vniKey = new VirtualNetworkIdentifierKey(new VniUri(Long.toString(InstanceIdentifierUtil.getLispInstanceId(eid))));
        MappingKey eidKey = new MappingKey(new EidUri(LispAddressStringifier.getURIString((LispAddress)eid)), orig);
        XtrIdMappingKey xtrIdKey = new XtrIdMappingKey(new XtrIdUri(LispAddressStringifier.getURIString((XtrId)xtrId)));
        return InstanceIdentifier.create(MappingDatabase.class).child(VirtualNetworkIdentifier.class, (Identifier)vniKey).child(Mapping.class, (Identifier)eidKey).child(XtrIdMapping.class, (Identifier)xtrIdKey);
    }

    private static long getLispInstanceId(Eid eid) {
        Address address = eid.getAddress();
        if (address instanceof InstanceId) {
            return ((InstanceId)address).getInstanceId().getIid().getValue();
        }
        if (eid.getVirtualNetworkId() != null) {
            return eid.getVirtualNetworkId().getValue();
        }
        return 0L;
    }
}

