/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.inmemorydb.radixtrie;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;

public class RadixTrie<T> {
    private int maxBits;
    private TrieNode root;
    private long nbActiveNodes;
    private boolean rootZero;

    public RadixTrie(int bits) {
        this.maxBits = bits;
        this.root = null;
        this.nbActiveNodes = 0L;
    }

    public RadixTrie(int bits, boolean rootZero) {
        this.maxBits = bits;
        this.root = rootZero ? new TrieNode(null, 0, null) : null;
        this.nbActiveNodes = 0L;
        this.rootZero = rootZero;
    }

    public TrieNode getRoot() {
        return this.root;
    }

    private void setRoot(TrieNode root) {
        this.root = root;
    }

    public int getMaxbits() {
        return this.maxBits;
    }

    public long getSize() {
        return this.nbActiveNodes;
    }

    private boolean testBitInByte(byte byteArg, int bitPosition) {
        return (byteArg & 128 >> bitPosition) != 0;
    }

    private boolean testBitInPrefixByte(byte[] prefix, int bitPosition) {
        return this.testBitInByte(prefix[bitPosition / 8], bitPosition & 7);
    }

    private byte[] maskPrefix(byte[] prefix, int prefLen) {
        byte[] res = (byte[])prefix.clone();
        res[prefLen / 8] = (byte)(res[prefLen / 8] & 255 << 7 - (prefLen & 7));
        for (int i = prefLen / 8 + 1; i < this.maxBits / 8; ++i) {
            res[i] = 0;
        }
        return res;
    }

    public TrieNode insert(byte[] prefix, int preflen, T data) {
        if (preflen > this.maxBits) {
            return null;
        }
        if (this.root == null) {
            this.root = new TrieNode(prefix, preflen, data);
            return this.root;
        }
        TrieNode closest = this.root.findClosest(prefix, preflen, false);
        int diffbit = closest.firstDifferentBit(prefix, preflen);
        TrieNode node = closest.parentWithBitLessThan(diffbit);
        return node.insert(prefix, preflen, diffbit, data, closest.prefix());
    }

    public TrieNode lookupBest(byte[] prefix, int preflen) {
        if (this.root == null || preflen > this.maxBits) {
            return null;
        }
        TrieNode node = this.root;
        ArrayList<TrieNode> candidates = new ArrayList<TrieNode>();
        while (node != null && node.bit < preflen) {
            if (node.prefix != null) {
                candidates.add(node);
            }
            if (this.testBitInPrefixByte(prefix, node.bit)) {
                node = node.right;
                continue;
            }
            node = node.left;
        }
        if (node != null && node.prefix != null) {
            candidates.add(node);
        }
        ListIterator it = candidates.listIterator(candidates.size());
        while (it.hasPrevious()) {
            node = (TrieNode)it.previous();
            if (!node.comparePrefix(prefix)) continue;
            return node;
        }
        return null;
    }

    public TrieNode lookupCoveringLessSpecific(byte[] prefix, int preflen) {
        if (this.root == null || preflen > this.maxBits) {
            return null;
        }
        TrieNode node = this.root.findClosest(prefix, preflen, true);
        if (node == null) {
            return null;
        }
        if (node.bit < preflen && node.prefix != null) {
            return node;
        }
        node = node.up;
        while (node != null && node.prefix == null) {
            node = node.up;
        }
        return node;
    }

    public TrieNode lookupParent(byte[] prefix, int preflen) {
        TrieNode node = this.lookupBest(prefix, preflen);
        if (node == null) {
            return null;
        }
        node = node.up;
        while (node != null && node.prefix == null) {
            node = node.up;
        }
        return node;
    }

    public TrieNode lookupSibling(byte[] prefix, int preflen) {
        TrieNode node = this.lookupBest(prefix, preflen);
        TrieNode sibling = node.sibling();
        if (sibling != null && sibling.prefix != null) {
            return sibling;
        }
        return null;
    }

    public TrieNode lookupVirtualParentSibling(byte[] prefix, int preflen) {
        TrieNode node = this.lookupBest(prefix, preflen);
        if (node == null || node.up == null) {
            return null;
        }
        if (node.up.prefix != null) {
            return null;
        }
        return node.up.sibling();
    }

    public TrieNode lookupWidestNegative(byte[] prefix, int preflen) {
        if (this.root == null || preflen > this.maxBits) {
            return null;
        }
        TrieNode node = this.root.findClosest(prefix, preflen, false);
        if (node.prefix != null && node.prefixLength() <= preflen && node.comparePrefix(prefix)) {
            return null;
        }
        int diffbit = node.firstDifferentBit(prefix, preflen);
        return new TrieNode(this.maskPrefix(prefix, diffbit), diffbit + 1, null);
    }

    public TrieNode lookupExact(byte[] prefix, int preflen) {
        if (this.root == null || preflen > this.maxBits) {
            return null;
        }
        TrieNode node = this.root.findClosest(prefix, preflen, false);
        if (node == null || node.prefix == null || node.bit != preflen) {
            return null;
        }
        if (node.comparePrefix(prefix)) {
            return node;
        }
        return null;
    }

    public Set<TrieNode> lookupSubtree(byte[] prefix, int preflen) {
        if (this.root == null || preflen > this.maxBits) {
            return Collections.emptySet();
        }
        TrieNode node2 = this.root.findClosest(prefix, preflen, true);
        HashSet<TrieNode> children = new HashSet<TrieNode>();
        if (node2.prefix != null && node2.bit >= preflen) {
            children.add(node2);
        }
        for (TrieNode node2 : node2) {
            if (node2.prefix == null || node2.bit < preflen) continue;
            children.add(node2);
        }
        return children;
    }

    public void remove(byte[] prefix, int preflen) {
        TrieNode node = this.lookupExact(prefix, preflen);
        if (node != null) {
            node.erase();
        }
    }

    public void removeAll() {
        for (TrieNode node : this.root) {
            node.erase();
        }
    }

    public class TrieNode
    implements Iterable<TrieNode> {
        int bit;
        byte[] prefix;
        TrieNode left;
        TrieNode right;
        TrieNode up;
        T data;

        TrieNode(byte[] prefix, int prefixlen, T data) {
            this.bit = prefixlen;
            this.prefix = prefix;
            this.data = data;
            this.left = null;
            this.right = null;
        }

        public byte[] prefix() {
            return this.prefix;
        }

        public int prefixLength() {
            return this.bit;
        }

        public T data() {
            return this.data;
        }

        public TrieNode findClosest(byte[] pref, int preflen, boolean virtual) {
            TrieNode node = this;
            while (!virtual && node.prefix == null || node.bit < preflen) {
                if (RadixTrie.this.testBitInPrefixByte(pref, node.bit)) {
                    if (node.right == null) break;
                    node = node.right;
                    continue;
                }
                if (node.left == null) break;
                node = node.left;
            }
            return node;
        }

        private int toUnsignedInt(byte byteToConvert) {
            return 0xFF & byteToConvert;
        }

        public int firstDifferentBit(byte[] pref, int preflen) {
            int maxbit = this.bit < preflen ? this.bit : preflen;
            int diffbit = 0;
            int i = 0;
            while (i * 8 < maxbit) {
                int bitxor = this.toUnsignedInt(this.prefix[i]) ^ this.toUnsignedInt(pref[i]);
                if (bitxor != 0) {
                    diffbit = i * 8 + Integer.numberOfLeadingZeros(bitxor) - 24;
                    break;
                }
                diffbit = (i + 1) * 8;
                ++i;
            }
            diffbit = diffbit > maxbit ? maxbit : diffbit;
            return diffbit;
        }

        public TrieNode parentWithBitLessThan(int bitlen) {
            TrieNode node = this;
            TrieNode parent = node.up;
            while (parent != null && parent.bit >= bitlen) {
                node = parent;
                parent = node.up;
            }
            return node;
        }

        public TrieNode sibling() {
            TrieNode node = this;
            if (node == null || node.up == null) {
                return null;
            }
            TrieNode sibling = null;
            sibling = node.up.left == node ? node.up.right : node.up.left;
            return sibling;
        }

        public TrieNode insert(byte[] pref, int preflen, int diffbit, T prefdata, byte[] closest) {
            if (diffbit == preflen && this.bit == preflen) {
                if (this.prefix != null) {
                    return this;
                }
                this.prefix = pref;
                this.data = prefdata;
                ++RadixTrie.this.nbActiveNodes;
                return this;
            }
            TrieNode newNode = new TrieNode(pref, preflen, prefdata);
            if (preflen == diffbit) {
                if (this.prefix == null ? RadixTrie.this.testBitInPrefixByte(closest, preflen) : RadixTrie.this.testBitInPrefixByte(this.prefix, preflen)) {
                    newNode.right = this;
                } else {
                    newNode.left = this;
                }
                newNode.up = this.up;
                if (this.up == null) {
                    RadixTrie.this.setRoot(newNode);
                } else if (this.equals(this.up.right)) {
                    this.up.right = newNode;
                } else {
                    this.up.left = newNode;
                }
                this.up = newNode;
            } else if (this.bit == diffbit) {
                newNode.up = this;
                if (RadixTrie.this.testBitInPrefixByte(pref, this.bit)) {
                    this.right = newNode;
                } else {
                    this.left = newNode;
                }
            } else {
                TrieNode parent = new TrieNode(null, diffbit, null);
                parent.up = this.up;
                if (RadixTrie.this.testBitInPrefixByte(pref, diffbit)) {
                    parent.right = newNode;
                    parent.left = this;
                } else {
                    parent.right = this;
                    parent.left = newNode;
                }
                newNode.up = parent;
                if (this.up == null) {
                    RadixTrie.this.setRoot(parent);
                } else if (this.equals(this.up.right)) {
                    this.up.right = parent;
                } else {
                    this.up.left = parent;
                }
                this.up = parent;
            }
            ++RadixTrie.this.nbActiveNodes;
            return newNode;
        }

        public void erase() {
            TrieNode cur = this;
            boolean isRoot = false;
            if (this.equals(RadixTrie.this.root)) {
                isRoot = true;
            }
            if (this.prefix != null) {
                this.resetData();
            }
            while (cur != null && cur.prefix == null && (cur.left == null || cur.right == null)) {
                TrieNode child;
                TrieNode parent = cur.up;
                TrieNode trieNode = child = cur.left != null ? cur.left : cur.right;
                if (parent == null) {
                    if (child != null) {
                        if (!RadixTrie.this.rootZero) {
                            child.up = null;
                            RadixTrie.this.setRoot(child);
                        }
                    } else {
                        isRoot = true;
                    }
                } else {
                    if (parent.left != null && parent.left.equals(cur)) {
                        parent.left = child;
                    } else {
                        parent.right = child;
                    }
                    if (child != null) {
                        child.up = parent;
                    }
                }
                cur.resetData();
                cur = parent;
            }
            if (isRoot) {
                RadixTrie.this.setRoot(RadixTrie.this.rootZero ? new TrieNode(null, 0, null) : null);
            }
            --RadixTrie.this.nbActiveNodes;
        }

        public void resetData() {
            this.prefix = null;
            this.data = null;
        }

        public boolean comparePrefix(byte[] pref) {
            int iterator;
            for (iterator = 0; iterator < this.bit / 8; ++iterator) {
                if (this.prefix[iterator] == pref[iterator]) continue;
                return false;
            }
            int remainder = this.bit % 8;
            if (remainder != 0) {
                int mask = 255 << 8 - remainder & 0xFF;
                return (this.prefix[iterator] & mask) == (pref[iterator] & mask);
            }
            return true;
        }

        public String asIpPrefix() {
            try {
                return InetAddress.getByAddress(this.prefix).getHostAddress() + "/" + this.bit;
            }
            catch (UnknownHostException e) {
                return "NaA/" + this.bit;
            }
        }

        @Override
        public Iterator<TrieNode> iterator() {
            return new TriePostOrderIterator(this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.printPrefixAndMask());
            if (this.up != null) {
                sb.append(", parent: ");
                sb.append(this.up.printPrefixAndMask());
            }
            if (this.left != null) {
                sb.append(", left child: ");
                sb.append(this.left.printPrefixAndMask());
            }
            if (this.right != null) {
                sb.append(", right child: ");
                sb.append(this.right.printPrefixAndMask());
            }
            if (this.data != null) {
                sb.append(", data: ");
                sb.append(this.data);
            }
            return sb.toString();
        }

        private String printPrefixAndMask() {
            if (this.prefix == null) {
                return "Virtual @ bit " + this.bit;
            }
            StringBuilder sb = new StringBuilder();
            try {
                sb.append(InetAddress.getByAddress(this.prefix));
                sb.append("/");
                sb.append(this.bit);
            }
            catch (UnknownHostException e) {
                return "NaP";
            }
            return sb.toString();
        }

        private class TriePostOrderIterator
        implements Iterator<TrieNode> {
            private TrieNode current;
            private TrieNode lastNodeVisited;
            private Deque<TrieNode> stack = new ArrayDeque<TrieNode>();

            TriePostOrderIterator(TrieNode node) {
                this.current = node;
                this.lastNodeVisited = null;
            }

            @Override
            public boolean hasNext() {
                TrieNode last = this.lastNodeVisited;
                if (this.current != null && (this.current.left != null || this.current.right != null)) {
                    return true;
                }
                for (TrieNode peekNode : this.stack) {
                    if (peekNode.right != null && !peekNode.right.equals(last)) {
                        return true;
                    }
                    last = peekNode;
                    if (peekNode.prefix == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public TrieNode next() {
                TrieNode next = this.current;
                while (!this.stack.isEmpty() || next != null) {
                    if (next != null) {
                        this.stack.push(next);
                        next = next.left;
                        continue;
                    }
                    TrieNode peekNode = this.stack.peek();
                    if (peekNode.right != null && !peekNode.right.equals(this.lastNodeVisited)) {
                        next = peekNode.right;
                        continue;
                    }
                    this.lastNodeVisited = this.stack.pop();
                    if (peekNode.prefix == null) continue;
                    this.current = null;
                    return peekNode;
                }
                return null;
            }
        }
    }
}

