/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.inmemorydb;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.lispflowmapping.inmemorydb.radixtrie.RadixTrie;
import org.opendaylight.lispflowmapping.interfaces.dao.ILispDAO;
import org.opendaylight.lispflowmapping.interfaces.dao.IRowVisitor;
import org.opendaylight.lispflowmapping.interfaces.dao.MappingEntry;
import org.opendaylight.lispflowmapping.lisp.util.LispAddressUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.InstanceIdType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.binary.address.types.rev160504.augmented.lisp.address.address.Ipv4PrefixBinary;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.binary.address.types.rev160504.augmented.lisp.address.address.Ipv6PrefixBinary;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashMapDb
implements ILispDAO,
AutoCloseable {
    protected static final Logger LOG = LoggerFactory.getLogger(HashMapDb.class);
    private static final Object TABLES = "tables";
    private ConcurrentMap<Object, ConcurrentMap<String, Object>> data = new ConcurrentHashMap<Object, ConcurrentMap<String, Object>>();
    private RadixTrie<Object> ip4Trie = new RadixTrie(32, true);
    private RadixTrie<Object> ip6Trie = new RadixTrie(128, true);

    public void tryAddToIpTrie(Object key) {
        if (key instanceof Eid) {
            Eid eid = (Eid)key;
            if (eid.getAddress() instanceof Ipv4PrefixBinary) {
                Ipv4PrefixBinary prefix = (Ipv4PrefixBinary)eid.getAddress();
                this.ip4Trie.insert(prefix.getIpv4AddressBinary().getValue(), prefix.getIpv4MaskLength().toJava(), key);
            } else if (eid.getAddress() instanceof Ipv6PrefixBinary) {
                Ipv6PrefixBinary prefix = (Ipv6PrefixBinary)eid.getAddress();
                this.ip6Trie.insert(prefix.getIpv6AddressBinary().getValue(), prefix.getIpv6MaskLength().toJava(), key);
            }
        }
    }

    public void put(Object key, MappingEntry<?> ... values) {
        if (!this.data.containsKey(key)) {
            this.data.put(key, new ConcurrentHashMap());
        }
        for (MappingEntry<?> entry : values) {
            this.tryAddToIpTrie(key);
            ((ConcurrentMap)this.data.get(key)).put(entry.getKey(), entry.getValue());
        }
    }

    public Object getSpecific(Object key, String valueKey) {
        Map keyToValues = (Map)this.data.get(key);
        if (keyToValues == null) {
            return null;
        }
        return keyToValues.get(valueKey);
    }

    public Map<String, Object> get(Object key) {
        return (Map)this.data.get(key);
    }

    private RadixTrie.TrieNode lookupBestNode(Eid eid) {
        if (eid.getAddress() instanceof Ipv4PrefixBinary) {
            Ipv4PrefixBinary prefix = (Ipv4PrefixBinary)eid.getAddress();
            return this.ip4Trie.lookupBest(prefix.getIpv4AddressBinary().getValue(), prefix.getIpv4MaskLength().toJava());
        }
        if (eid.getAddress() instanceof Ipv6PrefixBinary) {
            Ipv6PrefixBinary prefix = (Ipv6PrefixBinary)eid.getAddress();
            return this.ip6Trie.lookupBest(prefix.getIpv6AddressBinary().getValue(), prefix.getIpv6MaskLength().toJava());
        }
        return null;
    }

    public Map<String, Object> getBest(Object key) {
        if (key instanceof Eid) {
            Eid eid = (Eid)key;
            RadixTrie.TrieNode node = this.lookupBestNode(eid);
            if (node == null) {
                return this.get(key);
            }
            return this.get(node.data());
        }
        return null;
    }

    public AbstractMap.SimpleImmutableEntry<Eid, Map<String, ?>> getBestPair(Object key) {
        Map<String, Object> result = null;
        if (key instanceof Eid) {
            Eid eid = (Eid)key;
            RadixTrie.TrieNode node = this.lookupBestNode(eid);
            if (node == null) {
                result = this.get(key);
                return result == null ? null : new AbstractMap.SimpleImmutableEntry<Eid, Map<String, Object>>((Eid)key, result);
            }
            result = this.get(node.data());
            return result == null ? null : new AbstractMap.SimpleImmutableEntry<Eid, Map<String, Object>>((Eid)node.data(), result);
        }
        return null;
    }

    public void getAll(IRowVisitor visitor) {
        for (Map.Entry keyEntry : this.data.entrySet()) {
            for (Map.Entry valueEntry : ((ConcurrentMap)keyEntry.getValue()).entrySet()) {
                visitor.visitRow(keyEntry.getKey(), (String)valueEntry.getKey(), valueEntry.getValue());
            }
        }
    }

    private Eid getPrefix(Eid key, GetPrefixMethods method) {
        RadixTrie.TrieNode node = null;
        if (key.getAddress() instanceof Ipv4PrefixBinary) {
            Ipv4PrefixBinary prefix = (Ipv4PrefixBinary)key.getAddress();
            switch (method) {
                case COVERING: {
                    node = this.ip4Trie.lookupCoveringLessSpecific(prefix.getIpv4AddressBinary().getValue(), prefix.getIpv4MaskLength().toJava());
                    break;
                }
                case PARENT: {
                    node = this.ip4Trie.lookupParent(prefix.getIpv4AddressBinary().getValue(), prefix.getIpv4MaskLength().toJava());
                    break;
                }
                case SIBLING: {
                    node = this.ip4Trie.lookupSibling(prefix.getIpv4AddressBinary().getValue(), prefix.getIpv4MaskLength().toJava());
                    break;
                }
                case VIRTUAL_PARENT_SIBLING: {
                    node = this.ip4Trie.lookupVirtualParentSibling(prefix.getIpv4AddressBinary().getValue(), prefix.getIpv4MaskLength().toJava());
                    break;
                }
                case WIDEST_NEGATIVE: {
                    node = this.ip4Trie.lookupWidestNegative(prefix.getIpv4AddressBinary().getValue(), prefix.getIpv4MaskLength().toJava());
                    break;
                }
                default: {
                    node = null;
                }
            }
            if (node != null && node.prefix() != null) {
                return LispAddressUtil.asIpv4PrefixBinaryEid((InstanceIdType)key.getVirtualNetworkId(), (byte[])node.prefix(), (short)((short)node.prefixLength()));
            }
        } else if (key.getAddress() instanceof Ipv6PrefixBinary) {
            Ipv6PrefixBinary prefix = (Ipv6PrefixBinary)key.getAddress();
            switch (method) {
                case COVERING: {
                    node = this.ip6Trie.lookupCoveringLessSpecific(prefix.getIpv6AddressBinary().getValue(), prefix.getIpv6MaskLength().toJava());
                    break;
                }
                case PARENT: {
                    node = this.ip6Trie.lookupParent(prefix.getIpv6AddressBinary().getValue(), prefix.getIpv6MaskLength().toJava());
                    break;
                }
                case SIBLING: {
                    node = this.ip6Trie.lookupSibling(prefix.getIpv6AddressBinary().getValue(), prefix.getIpv6MaskLength().toJava());
                    break;
                }
                case VIRTUAL_PARENT_SIBLING: {
                    node = this.ip6Trie.lookupVirtualParentSibling(prefix.getIpv6AddressBinary().getValue(), prefix.getIpv6MaskLength().toJava());
                    break;
                }
                case WIDEST_NEGATIVE: {
                    node = this.ip6Trie.lookupWidestNegative(prefix.getIpv6AddressBinary().getValue(), prefix.getIpv6MaskLength().toJava());
                    break;
                }
                default: {
                    node = null;
                }
            }
            if (node != null && node.prefix() != null) {
                return LispAddressUtil.asIpv6PrefixBinaryEid((InstanceIdType)key.getVirtualNetworkId(), (byte[])node.prefix(), (short)((short)node.prefixLength()));
            }
        }
        return null;
    }

    public Eid getCoveringLessSpecific(Eid key) {
        return this.getPrefix(key, GetPrefixMethods.COVERING);
    }

    public Eid getParentPrefix(Eid key) {
        return this.getPrefix(key, GetPrefixMethods.PARENT);
    }

    public Eid getSiblingPrefix(Eid key) {
        return this.getPrefix(key, GetPrefixMethods.SIBLING);
    }

    public Eid getVirtualParentSiblingPrefix(Eid key) {
        return this.getPrefix(key, GetPrefixMethods.VIRTUAL_PARENT_SIBLING);
    }

    public Eid getWidestNegativePrefix(Eid key) {
        return this.getPrefix(key, GetPrefixMethods.WIDEST_NEGATIVE);
    }

    public Set<Eid> getSubtree(Eid key) {
        Set<RadixTrie.TrieNode> nodes = null;
        if (key.getAddress() instanceof Ipv4PrefixBinary) {
            Ipv4PrefixBinary prefix = (Ipv4PrefixBinary)key.getAddress();
            nodes = this.ip4Trie.lookupSubtree(prefix.getIpv4AddressBinary().getValue(), prefix.getIpv4MaskLength().toJava());
        } else if (key.getAddress() instanceof Ipv6PrefixBinary) {
            Ipv6PrefixBinary prefix = (Ipv6PrefixBinary)key.getAddress();
            nodes = this.ip6Trie.lookupSubtree(prefix.getIpv6AddressBinary().getValue(), prefix.getIpv6MaskLength().toJava());
        }
        return HashMapDb.nodesToEids(key, nodes);
    }

    private static Set<Eid> nodesToEids(Eid key, Set<RadixTrie.TrieNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Eid> children = new HashSet<Eid>();
        for (RadixTrie.TrieNode node : nodes) {
            if (key.getAddress() instanceof Ipv4PrefixBinary) {
                children.add(LispAddressUtil.asIpv4PrefixBinaryEid((InstanceIdType)key.getVirtualNetworkId(), (byte[])node.prefix(), (short)((short)node.prefixLength())));
                continue;
            }
            if (!(key.getAddress() instanceof Ipv6PrefixBinary)) continue;
            children.add(LispAddressUtil.asIpv6PrefixBinaryEid((InstanceIdType)key.getVirtualNetworkId(), (byte[])node.prefix(), (short)((short)node.prefixLength())));
        }
        return children;
    }

    private void tryRemoveFromTrie(Object key) {
        if (key instanceof Eid) {
            Eid eid = (Eid)key;
            if (eid.getAddress() instanceof Ipv4PrefixBinary) {
                Ipv4PrefixBinary prefix = (Ipv4PrefixBinary)eid.getAddress();
                this.ip4Trie.remove(prefix.getIpv4AddressBinary().getValue(), prefix.getIpv4MaskLength().toJava());
            } else if (eid.getAddress() instanceof Ipv6PrefixBinary) {
                Ipv6PrefixBinary prefix = (Ipv6PrefixBinary)eid.getAddress();
                this.ip6Trie.remove(prefix.getIpv6AddressBinary().getValue(), prefix.getIpv6MaskLength().toJava());
            }
        }
    }

    public void remove(Object key) {
        this.tryRemoveFromTrie(key);
        this.data.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSpecific(Object key, String valueKey) {
        Map keyToValues = (Map)this.data.get(key);
        if (keyToValues == null) {
            return;
        }
        Map map = keyToValues;
        synchronized (map) {
            if (keyToValues.containsKey(valueKey)) {
                keyToValues.remove(valueKey);
                if (keyToValues.isEmpty()) {
                    this.remove(key);
                }
            }
        }
    }

    public void removeAll() {
        this.ip4Trie.removeAll();
        this.ip6Trie.removeAll();
        this.data.clear();
    }

    @Override
    public void close() throws Exception {
        this.data.clear();
    }

    public ILispDAO putNestedTable(Object key, String valueKey) {
        ILispDAO nestedTable = (ILispDAO)this.getSpecific(key, valueKey);
        if (nestedTable != null) {
            LOG.warn("Trying to add nested table that already exists. Aborting!");
            return nestedTable;
        }
        nestedTable = new HashMapDb();
        this.put(key, new MappingEntry(valueKey, (Object)nestedTable));
        return nestedTable;
    }

    public ILispDAO putTable(String key) {
        ILispDAO table = (ILispDAO)this.getSpecific(TABLES, key);
        if (table != null) {
            LOG.warn("Trying to add table that already exists. Aborting!");
            return table;
        }
        table = new HashMapDb();
        this.put(TABLES, new MappingEntry(key, (Object)table));
        return table;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    private static enum GetPrefixMethods {
        PARENT,
        SIBLING,
        VIRTUAL_PARENT_SIBLING,
        WIDEST_NEGATIVE,
        COVERING;

    }
}

