/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.mapcache;

import org.opendaylight.lispflowmapping.interfaces.dao.ILispDAO;
import org.opendaylight.lispflowmapping.interfaces.dao.IRowVisitor;
import org.opendaylight.lispflowmapping.interfaces.dao.MappingEntry;
import org.opendaylight.lispflowmapping.interfaces.mapcache.IAuthKeyDb;
import org.opendaylight.lispflowmapping.lisp.util.MaskUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.SourceDestKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthKeyDb
implements IAuthKeyDb {
    private static final Logger LOG = LoggerFactory.getLogger(AuthKeyDb.class);
    private ILispDAO dao;

    public AuthKeyDb(ILispDAO dao) {
        this.dao = dao;
    }

    private long getVni(Eid eid) {
        if (eid.getVirtualNetworkId() == null) {
            return 0L;
        }
        return eid.getVirtualNetworkId().getValue();
    }

    private ILispDAO getVniTable(Eid eid) {
        return (ILispDAO)this.dao.getSpecific((Object)this.getVni(eid), "vni");
    }

    private void removeVniTable(Eid eid) {
        this.dao.removeSpecific((Object)this.getVni(eid), "vni");
    }

    private ILispDAO getOrInstantiateVniTable(Eid eid) {
        long vni = this.getVni(eid);
        ILispDAO table = (ILispDAO)this.dao.getSpecific((Object)vni, "vni");
        if (table == null) {
            table = this.dao.putNestedTable((Object)vni, "vni");
        }
        return table;
    }

    public void addAuthenticationKey(Eid eid, MappingAuthkey authKey) {
        Eid key = MaskUtil.normalize((Eid)eid);
        ILispDAO table = this.getOrInstantiateVniTable(key);
        table.put((Object)key, new MappingEntry[]{new MappingEntry("password", (Object)authKey)});
    }

    private MappingAuthkey getAuthKeyLpm(Eid prefix, ILispDAO db) {
        for (short maskLength = MaskUtil.getMaskForAddress((Address)prefix.getAddress()); maskLength >= 0; maskLength = (short)(maskLength - 1)) {
            Eid key = MaskUtil.normalize((Eid)prefix, (short)maskLength);
            Object password = db.getSpecific((Object)key, "password");
            if (password == null || !(password instanceof MappingAuthkey)) continue;
            return (MappingAuthkey)password;
        }
        return null;
    }

    public MappingAuthkey getAuthenticationKey(Eid eid) {
        ILispDAO table = this.getVniTable(eid);
        if (table == null) {
            return null;
        }
        if (MaskUtil.isMaskable((Address)eid.getAddress()) && !(eid.getAddress() instanceof SourceDestKey)) {
            return this.getAuthKeyLpm(eid, table);
        }
        Eid key = MaskUtil.normalize((Eid)eid);
        Object password = table.getSpecific((Object)key, "password");
        if (password != null && password instanceof MappingAuthkey) {
            return (MappingAuthkey)password;
        }
        LOG.warn("Failed to find password!");
        return null;
    }

    public void removeAuthenticationKey(Eid eid) {
        Eid key = MaskUtil.normalize((Eid)eid);
        ILispDAO table = this.getVniTable(key);
        if (table == null) {
            return;
        }
        table.removeSpecific((Object)key, "password");
        if (table.isEmpty()) {
            this.removeVniTable(eid);
        }
    }

    public String printKeys() {
        final StringBuffer sb = new StringBuffer();
        sb.append("Keys\tValues\n");
        final IRowVisitor innerVisitor = new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                sb.append(valueKey + "=" + value + "\t");
                this.lastKey = key;
            }
        };
        this.dao.getAll(new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                if (valueKey.equals("vni")) {
                    sb.append(valueKey + "= { ");
                    ((ILispDAO)value).getAll(innerVisitor);
                    sb.append("}\t");
                } else {
                    sb.append(valueKey + "=" + value + "\t");
                }
                this.lastKey = key;
            }
        });
        sb.append("\n");
        return sb.toString();
    }
}

