/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.mapcache;

import org.opendaylight.lispflowmapping.interfaces.dao.ILispDAO;
import org.opendaylight.lispflowmapping.interfaces.dao.IRowVisitor;
import org.opendaylight.lispflowmapping.interfaces.dao.MappingEntry;
import org.opendaylight.lispflowmapping.interfaces.mapcache.IMapCache;
import org.opendaylight.lispflowmapping.lisp.util.MaskUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;

public class FlatMapCache
implements IMapCache {
    private ILispDAO dao;

    public FlatMapCache(ILispDAO dao) {
        this.dao = dao;
    }

    public void addMapping(Eid eid, Object value) {
        Eid key = MaskUtil.normalize((Eid)eid);
        this.dao.put((Object)key, new MappingEntry[]{new MappingEntry("address", value)});
    }

    public Object getMapping(Eid srcKey, Eid dstKey) {
        if (dstKey == null) {
            return null;
        }
        Eid key = MaskUtil.normalize((Eid)dstKey);
        return this.dao.getSpecific((Object)key, "address");
    }

    public Eid getWidestNegativeMapping(Eid key) {
        return null;
    }

    public void removeMapping(Eid eid) {
        Eid key = MaskUtil.normalize((Eid)eid);
        this.dao.removeSpecific((Object)key, "address");
    }

    public void addData(Eid eid, String subKey, Object value) {
        Eid key = MaskUtil.normalize((Eid)eid);
        this.dao.put((Object)key, new MappingEntry[]{new MappingEntry(subKey, value)});
    }

    public Object getData(Eid eid, String subKey) {
        Eid key = MaskUtil.normalize((Eid)eid);
        return this.dao.getSpecific((Object)key, subKey);
    }

    public void removeData(Eid eid, String subKey) {
        Eid key = MaskUtil.normalize((Eid)eid);
        this.dao.removeSpecific((Object)key, subKey);
    }

    public String printMappings() {
        final StringBuffer sb = new StringBuffer();
        sb.append("Keys\tValues\n");
        this.dao.getAll(new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                sb.append(valueKey + "=" + value + "\t");
                this.lastKey = key;
            }
        });
        sb.append("\n");
        return sb.toString();
    }
}

