/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.mapcache;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.lispflowmapping.interfaces.dao.ILispDAO;
import org.opendaylight.lispflowmapping.interfaces.dao.IRowVisitor;
import org.opendaylight.lispflowmapping.interfaces.dao.MappingEntry;
import org.opendaylight.lispflowmapping.interfaces.mapcache.ILispMapCache;
import org.opendaylight.lispflowmapping.lisp.util.MaskUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.inet.binary.types.rev160303.IpAddressBinary;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.XtrId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;

public class SimpleMapCache
implements ILispMapCache {
    private ILispDAO dao;

    public SimpleMapCache(ILispDAO dao) {
        this.dao = dao;
    }

    private long getVni(Eid eid) {
        if (eid.getVirtualNetworkId() == null) {
            return 0L;
        }
        return eid.getVirtualNetworkId().getValue();
    }

    private ILispDAO getVniTable(Eid eid) {
        return (ILispDAO)this.dao.getSpecific((Object)this.getVni(eid), "vni");
    }

    private void removeVniTable(Eid eid) {
        this.dao.removeSpecific((Object)this.getVni(eid), "vni");
    }

    private ILispDAO getOrInstantiateVniTable(Eid eid) {
        long vni = this.getVni(eid);
        ILispDAO table = (ILispDAO)this.dao.getSpecific((Object)vni, "vni");
        if (table == null) {
            table = this.dao.putNestedTable((Object)vni, "vni");
        }
        return table;
    }

    private ILispDAO getOrInstantiateXtrIdTable(Eid eid, ILispDAO dao) {
        ILispDAO table = (ILispDAO)dao.getSpecific((Object)eid, "xtrid");
        if (table == null) {
            table = dao.putNestedTable((Object)eid, "xtrid");
        }
        return table;
    }

    public void addMapping(Eid key, Object value) {
        this.addMapping(key, value, null);
    }

    public void addMapping(Eid key, Object value, Set<IpAddressBinary> sourceRlocs) {
        Eid eid = MaskUtil.normalize((Eid)key);
        ILispDAO table = this.getOrInstantiateVniTable(key);
        table.put((Object)eid, new MappingEntry[]{new MappingEntry("address", value)});
        if (sourceRlocs != null) {
            table.put((Object)eid, new MappingEntry[]{new MappingEntry("src_rlocs", sourceRlocs)});
        }
    }

    public void addMapping(Eid key, XtrId xtrId, Object value) {
        Eid eid = MaskUtil.normalize((Eid)key);
        ILispDAO table = this.getOrInstantiateVniTable(key);
        ILispDAO xtrIdDao = this.getOrInstantiateXtrIdTable(eid, table);
        xtrIdDao.put((Object)xtrId, new MappingEntry[]{new MappingEntry("address", value)});
    }

    private Object getMappingLpmEid(Eid eid, XtrId xtrId, ILispDAO dao) {
        AbstractMap.SimpleImmutableEntry daoEntry = dao.getBestPair((Object)MaskUtil.normalize((Eid)eid));
        if (daoEntry != null) {
            if (xtrId != null) {
                ILispDAO xtrIdTable = (ILispDAO)((Map)daoEntry.getValue()).get("xtrid");
                if (xtrIdTable != null) {
                    return xtrIdTable.getSpecific((Object)xtrId, "address");
                }
            } else {
                return ((Map)daoEntry.getValue()).get("address");
            }
        }
        return null;
    }

    public Object getMapping(Eid srcEid, Eid dstEid) {
        XtrId xtrId = null;
        return this.getMapping(dstEid, xtrId);
    }

    public Object getMapping(Eid eid, XtrId xtrId) {
        if (eid == null) {
            return null;
        }
        ILispDAO table = this.getVniTable(eid);
        if (table == null) {
            return null;
        }
        return this.getMappingLpmEid(eid, xtrId, table);
    }

    private List<Object> getXtrIdMappingList(ILispDAO dao) {
        if (dao != null) {
            final ArrayList<Object> records = new ArrayList<Object>();
            dao.getAll(new IRowVisitor(){

                public void visitRow(Object keyId, String valueKey, Object value) {
                    if (valueKey.equals("address")) {
                        records.add(value);
                    }
                }
            });
            return records;
        }
        return null;
    }

    public List<Object> getAllXtrIdMappings(Eid eid) {
        ILispDAO xtrIdTable;
        ILispDAO table = this.getVniTable(eid);
        if (table == null) {
            return null;
        }
        Map daoEntry = table.getBest((Object)MaskUtil.normalize((Eid)eid));
        if (daoEntry != null && (xtrIdTable = (ILispDAO)daoEntry.get("xtrid")) != null) {
            return this.getXtrIdMappingList(xtrIdTable);
        }
        return null;
    }

    public Eid getWidestNegativeMapping(Eid eid) {
        ILispDAO table = this.getVniTable(eid);
        if (table == null) {
            return MaskUtil.normalize((Eid)eid, (short)0);
        }
        return table.getWidestNegativePrefix(MaskUtil.normalize((Eid)eid));
    }

    public Eid getParentPrefix(Eid eid) {
        ILispDAO table = this.getVniTable(eid);
        if (table == null) {
            return null;
        }
        return table.getParentPrefix(MaskUtil.normalize((Eid)eid));
    }

    public Eid getSiblingPrefix(Eid eid) {
        ILispDAO table = this.getVniTable(eid);
        if (table == null) {
            return null;
        }
        return table.getSiblingPrefix(MaskUtil.normalize((Eid)eid));
    }

    public Eid getVirtualParentSiblingPrefix(Eid eid) {
        ILispDAO table = this.getVniTable(eid);
        if (table == null) {
            return null;
        }
        return table.getVirtualParentSiblingPrefix(MaskUtil.normalize((Eid)eid));
    }

    public void removeMapping(Eid eid) {
        ILispDAO table = this.getVniTable(eid);
        if (table == null) {
            return;
        }
        Eid key = MaskUtil.normalize((Eid)eid);
        table.remove((Object)key);
        if (table.isEmpty()) {
            this.removeVniTable(eid);
        }
    }

    public void removeMapping(Eid eid, XtrId xtrId) {
        List<XtrId> xtrIds = Arrays.asList(xtrId);
        this.removeXtrIdMappings(eid, xtrIds);
    }

    public void removeXtrIdMappings(Eid eid, List<XtrId> xtrIds) {
        ILispDAO table = this.getVniTable(eid);
        if (table == null) {
            return;
        }
        Eid key = MaskUtil.normalize((Eid)eid);
        ILispDAO xtrIdTable = (ILispDAO)table.getSpecific((Object)key, "xtrid");
        if (xtrIdTable == null) {
            return;
        }
        for (XtrId xtrId : xtrIds) {
            xtrIdTable.removeSpecific((Object)xtrId, "address");
        }
        if (xtrIdTable.isEmpty()) {
            table.removeSpecific((Object)key, "xtrid");
            if (table.isEmpty()) {
                this.removeVniTable(eid);
            }
        }
    }

    public void addData(Eid eid, String subKey, Object data) {
        ILispDAO table = this.getOrInstantiateVniTable(eid);
        Eid key = MaskUtil.normalize((Eid)eid);
        table.put((Object)key, new MappingEntry[]{new MappingEntry(subKey, data)});
    }

    public Object getData(Eid eid, String subKey) {
        ILispDAO table = this.getVniTable(eid);
        if (table == null) {
            return null;
        }
        Eid key = MaskUtil.normalize((Eid)eid);
        return table.getSpecific((Object)key, subKey);
    }

    public void removeData(Eid eid, String subKey) {
        ILispDAO table = this.getVniTable(eid);
        if (table == null) {
            return;
        }
        Eid key = MaskUtil.normalize((Eid)eid);
        table.removeSpecific((Object)key, subKey);
        if (table.isEmpty()) {
            this.removeVniTable(eid);
        }
    }

    public String printMappings() {
        final StringBuffer sb = new StringBuffer();
        sb.append("Keys\tValues\n");
        final IRowVisitor innerVisitor = new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                sb.append(valueKey + "=" + value + "\t");
                this.lastKey = key;
            }
        };
        this.dao.getAll(new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                if (valueKey.equals("vni")) {
                    sb.append(valueKey + "= { ");
                    ((ILispDAO)value).getAll(innerVisitor);
                    sb.append("}\t");
                } else {
                    sb.append(valueKey + "=" + value + "\t");
                }
                this.lastKey = key;
            }
        });
        sb.append("\n");
        return sb.toString();
    }
}

