/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.mapcache;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.opendaylight.lispflowmapping.interfaces.dao.ILispDAO;
import org.opendaylight.lispflowmapping.interfaces.dao.MappingEntry;
import org.opendaylight.lispflowmapping.interfaces.mapcache.IMapCache;
import org.opendaylight.lispflowmapping.lisp.util.LispAddressUtil;
import org.opendaylight.lispflowmapping.lisp.util.MaskUtil;
import org.opendaylight.lispflowmapping.lisp.util.SourceDestKeyHelper;
import org.opendaylight.lispflowmapping.mapcache.lisp.LispMapCacheStringifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.SourceDestKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;

public class MultiTableMapCache
implements IMapCache {
    private ILispDAO dao;

    public MultiTableMapCache(ILispDAO dao) {
        this.dao = dao;
    }

    private long getVni(Eid eid) {
        if (eid.getVirtualNetworkId() == null) {
            return 0L;
        }
        return eid.getVirtualNetworkId().getValue();
    }

    private ILispDAO getVniTable(Eid eid) {
        return (ILispDAO)this.dao.getSpecific((Object)this.getVni(eid), "vni");
    }

    private void removeVniTable(Eid eid) {
        this.dao.removeSpecific((Object)this.getVni(eid), "vni");
    }

    private ILispDAO getOrInstantiateVniTable(Eid eid) {
        long vni = this.getVni(eid);
        ILispDAO table = (ILispDAO)this.dao.getSpecific((Object)vni, "vni");
        if (table == null) {
            table = this.dao.putNestedTable((Object)vni, "vni");
        }
        return table;
    }

    public void addMapping(Eid key, Object value) {
        Eid eid = MaskUtil.normalize((Eid)key);
        ILispDAO table = this.getOrInstantiateVniTable(key);
        if (eid.getAddress() instanceof SourceDestKey) {
            Eid srcKey = SourceDestKeyHelper.getSrcBinary((Eid)eid);
            ILispDAO srcDstDao = this.getOrInstantiateSDInnerDao(eid, table);
            srcDstDao.put((Object)srcKey, new MappingEntry[]{new MappingEntry("address", value)});
        } else {
            table.put((Object)eid, new MappingEntry[]{new MappingEntry("address", value)});
        }
    }

    private Object getMappingLpmEid(Eid eid, ILispDAO mappingsDb) {
        if (eid == null) {
            return null;
        }
        Map daoEntry = mappingsDb.getBest((Object)MaskUtil.normalize((Eid)eid));
        if (daoEntry != null) {
            return daoEntry.get("address");
        }
        return null;
    }

    private Object getMappingLpmSD(Eid srcEid, Eid dstEid, ILispDAO mappingsDb) {
        Map daoEntry = mappingsDb.getBest((Object)MaskUtil.normalize((Eid)dstEid));
        if (daoEntry != null) {
            Object mapping;
            ILispDAO srcDstDao = (ILispDAO)daoEntry.get("lcaf_srcdst");
            if (srcEid != null && srcDstDao != null && (mapping = this.getMappingLpmEid(LispAddressUtil.asIpPrefixBinaryEid((Eid)srcEid), srcDstDao)) != null) {
                return mapping;
            }
            return daoEntry.get("address");
        }
        return null;
    }

    public Object getMapping(Eid srcEid, Eid dstEid) {
        if (dstEid == null) {
            return null;
        }
        ILispDAO table = this.getVniTable(dstEid);
        if (table == null) {
            return null;
        }
        if (dstEid.getAddress() instanceof SourceDestKey) {
            Eid srcAddr = SourceDestKeyHelper.getSrcBinary((Eid)dstEid);
            Eid dstAddr = SourceDestKeyHelper.getDstBinary((Eid)dstEid);
            return this.getMappingLpmSD(srcAddr, dstAddr, table);
        }
        return this.getMappingLpmSD(srcEid, dstEid, table);
    }

    public Eid getWidestNegativeMapping(Eid key) {
        ILispDAO table = this.getVniTable(key);
        if (table == null) {
            return MaskUtil.normalize((Eid)key, (short)0);
        }
        return table.getWidestNegativePrefix(key);
    }

    public Set<Eid> getSubtree(Eid key) {
        ILispDAO table = this.getVniTable(key);
        if (table == null) {
            return Collections.emptySet();
        }
        return table.getSubtree(key);
    }

    public void removeMapping(Eid eid) {
        Eid key = MaskUtil.normalize((Eid)eid);
        ILispDAO table = this.getVniTable(key);
        if (table == null) {
            return;
        }
        if (key.getAddress() instanceof SourceDestKey) {
            ILispDAO db = this.getSDInnerDao(key, table);
            if (db != null) {
                db.remove((Object)SourceDestKeyHelper.getSrcBinary((Eid)key));
                if (db.isEmpty()) {
                    this.removeSDInnerDao(key, table);
                }
            }
        } else {
            table.remove((Object)key);
        }
        if (table.isEmpty()) {
            this.removeVniTable(eid);
        }
    }

    private ILispDAO getOrInstantiateSDInnerDao(Eid address, ILispDAO mappingsDb) {
        Eid dstKey = SourceDestKeyHelper.getDstBinary((Eid)address);
        ILispDAO srcDstDao = (ILispDAO)mappingsDb.getSpecific((Object)dstKey, "lcaf_srcdst");
        if (srcDstDao == null) {
            srcDstDao = mappingsDb.putNestedTable((Object)dstKey, "lcaf_srcdst");
        }
        return srcDstDao;
    }

    private ILispDAO getSDInnerDao(Eid address, ILispDAO mappingsDb) {
        return (ILispDAO)mappingsDb.getSpecific((Object)SourceDestKeyHelper.getDstBinary((Eid)address), "lcaf_srcdst");
    }

    private void removeSDInnerDao(Eid address, ILispDAO mappingsDb) {
        mappingsDb.removeSpecific((Object)SourceDestKeyHelper.getDstBinary((Eid)address), "lcaf_srcdst");
    }

    public void addData(Eid eid, String subKey, Object data) {
        Eid key = MaskUtil.normalize((Eid)eid);
        ILispDAO table = this.getOrInstantiateVniTable(key);
        if (key.getAddress() instanceof SourceDestKey) {
            ILispDAO srcDstDao = this.getOrInstantiateSDInnerDao(key, table);
            srcDstDao.put((Object)SourceDestKeyHelper.getSrcBinary((Eid)key), new MappingEntry[]{new MappingEntry(subKey, data)});
        } else {
            table.put((Object)key, new MappingEntry[]{new MappingEntry(subKey, data)});
        }
    }

    public Object getData(Eid eid, String subKey) {
        Eid key = MaskUtil.normalize((Eid)eid);
        ILispDAO table = this.getVniTable(key);
        if (table == null) {
            return null;
        }
        if (key.getAddress() instanceof SourceDestKey) {
            ILispDAO srcDstDao = this.getSDInnerDao(key, table);
            return srcDstDao.getSpecific((Object)SourceDestKeyHelper.getSrcBinary((Eid)key), subKey);
        }
        return table.getSpecific((Object)key, subKey);
    }

    public void removeData(Eid eid, String subKey) {
        Eid key = MaskUtil.normalize((Eid)eid);
        ILispDAO table = this.getVniTable(key);
        if (table == null) {
            return;
        }
        if (key.getAddress() instanceof SourceDestKey) {
            ILispDAO db = this.getSDInnerDao(key, table);
            if (db != null) {
                db.removeSpecific((Object)SourceDestKeyHelper.getSrcBinary((Eid)key), subKey);
                if (db.isEmpty()) {
                    this.removeSDInnerDao(key, table);
                }
            }
        } else {
            table.removeSpecific((Object)key, subKey);
        }
        if (table.isEmpty()) {
            this.removeVniTable(eid);
        }
    }

    public String printMappings() {
        return LispMapCacheStringifier.printMTMCMappings(this.dao);
    }

    public String prettyPrintMappings() {
        return LispMapCacheStringifier.prettyPrintMTMCMappings(this.dao);
    }
}

