/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.mapcache.lisp;

import java.util.Set;
import org.opendaylight.lispflowmapping.interfaces.dao.ILispDAO;
import org.opendaylight.lispflowmapping.interfaces.dao.IRowVisitor;
import org.opendaylight.lispflowmapping.interfaces.dao.Subscriber;
import org.opendaylight.lispflowmapping.lisp.authentication.LispKeyIDEnum;
import org.opendaylight.lispflowmapping.lisp.type.MappingData;
import org.opendaylight.lispflowmapping.lisp.util.LispAddressStringifier;
import org.opendaylight.lispflowmapping.lisp.util.Stringifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.LispAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;

public final class LispMapCacheStringifier {
    private LispMapCacheStringifier() {
    }

    public static String printKeys(ILispDAO dao) {
        final StringBuilder sb = new StringBuilder();
        sb.append("Keys\tValues\n");
        final IRowVisitor innerVisitor = new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                sb.append(valueKey + "=" + value + "\t");
                this.lastKey = key;
            }
        };
        dao.getAll(new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                if (valueKey.equals("vni")) {
                    sb.append(valueKey + "= { ");
                    ((ILispDAO)value).getAll(innerVisitor);
                    sb.append("}\t");
                } else {
                    sb.append(valueKey + "=" + value + "\t");
                }
                this.lastKey = key;
            }
        });
        sb.append("\n");
        return sb.toString();
    }

    public static String prettyPrintKeys(ILispDAO dao) {
        final StringBuilder sb = new StringBuilder();
        final IRowVisitor innerVisitor = new IRowVisitor(){

            public void visitRow(Object keyId, String valueKey, Object value) {
                switch (valueKey) {
                    case "password": {
                        String eid = LispAddressStringifier.getString((LispAddress)((Eid)keyId));
                        sb.append("     ");
                        sb.append(eid);
                        int padLen = Math.max(2, 46 - eid.length());
                        sb.append(Stringifier.getSpacesAsString((int)padLen));
                        MappingAuthkey authKey = (MappingAuthkey)value;
                        String hmac = LispKeyIDEnum.valueOf((short)authKey.getKeyType().shortValue()).getAuthenticationName();
                        sb.append(hmac);
                        sb.append(Stringifier.getSpacesAsString((int)Math.max(2, 22 - hmac.length())));
                        sb.append(authKey.getKeyString());
                        sb.append("\n");
                        break;
                    }
                }
            }
        };
        dao.getAll(new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("Instance ID " + keyId + "\n");
                    sb.append("  -> EID                                           HMAC Algorithm        Shared Key\n");
                }
                if (valueKey.equals("vni")) {
                    ((ILispDAO)value).getAll(innerVisitor);
                }
                this.lastKey = key;
            }
        });
        return sb.toString();
    }

    public static String printFMCMappings(ILispDAO dao) {
        final StringBuilder sb = new StringBuilder();
        sb.append("Keys\tValues\n");
        dao.getAll(new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                sb.append(valueKey + "=" + value + "\t");
                this.lastKey = key;
            }
        });
        sb.append("\n");
        return sb.toString();
    }

    public static String prettyPrintFMCMappings(ILispDAO dao) {
        final StringBuilder sb = new StringBuilder();
        dao.getAll(new IRowVisitor(){

            public void visitRow(Object keyId, String valueKey, Object value) {
                switch (valueKey) {
                    case "address": {
                        MappingData md = (MappingData)value;
                        sb.append(Stringifier.getString((MappingRecord)md.getRecord(), (int)2));
                        sb.append("\n");
                        break;
                    }
                }
            }
        });
        sb.append("\n");
        return sb.toString();
    }

    public static String printMTMCMappings(ILispDAO dao) {
        final StringBuilder sb = new StringBuilder();
        sb.append("Keys\tValues\n");
        final IRowVisitor innerVisitor = new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                sb.append(valueKey + "=" + value + "\t");
                this.lastKey = key;
            }
        };
        final IRowVisitor vniVisitor = new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append(key + "\t");
                }
                if (valueKey.equals("lcaf_srcdst")) {
                    sb.append(valueKey + "= { ");
                    ((ILispDAO)value).getAll(innerVisitor);
                    sb.append("}\t");
                } else {
                    sb.append(valueKey + "=" + value + "\t");
                }
                this.lastKey = key;
            }
        };
        dao.getAll(new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                if (valueKey.equals("vni")) {
                    sb.append(valueKey + "= { ");
                    ((ILispDAO)value).getAll(vniVisitor);
                    sb.append("}\t");
                } else {
                    sb.append(valueKey + "=" + value + "\t");
                }
                this.lastKey = key;
            }
        });
        sb.append("\n");
        return sb.toString();
    }

    public static String prettyPrintMTMCMappings(ILispDAO dao) {
        final StringBuilder sb = new StringBuilder();
        final IRowVisitor mappingVisitor = new IRowVisitor(){

            public void visitRow(Object keyId, String valueKey, Object value) {
                switch (valueKey) {
                    case "address": {
                        MappingData md = (MappingData)value;
                        sb.append(Stringifier.getString((MappingRecord)md.getRecord(), (int)2));
                        sb.append("\n");
                        break;
                    }
                    case "subscribers": {
                        Set subscribers = (Set)value;
                        sb.append(LispMapCacheStringifier.prettyPrintSubscriberSet(subscribers, 4));
                        sb.append("\n");
                        break;
                    }
                    case "lcaf_srcdst": {
                        ((ILispDAO)value).getAll((IRowVisitor)this);
                        break;
                    }
                }
            }
        };
        dao.getAll(new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("Instance ID " + keyId + "\n");
                }
                if (valueKey.equals("vni")) {
                    ((ILispDAO)value).getAll(mappingVisitor);
                }
                this.lastKey = key;
            }
        });
        return sb.toString();
    }

    public static String printSMCMappings(ILispDAO dao) {
        final StringBuilder sb = new StringBuilder();
        sb.append("Keys\tValues\n");
        final IRowVisitor innerVisitor = new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                sb.append(valueKey + "=" + value + "\t");
                this.lastKey = key;
            }
        };
        dao.getAll(new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("\n" + key + "\t");
                }
                if (valueKey.equals("vni")) {
                    sb.append(valueKey + "= { ");
                    ((ILispDAO)value).getAll(innerVisitor);
                    sb.append("}\t");
                } else {
                    sb.append(valueKey + "=" + value + "\t");
                }
                this.lastKey = key;
            }
        });
        sb.append("\n");
        return sb.toString();
    }

    public static String prettyPrintSMCMappings(ILispDAO dao) {
        final StringBuilder sb = new StringBuilder();
        final IRowVisitor mappingVisitor = new IRowVisitor(){

            public void visitRow(Object keyId, String valueKey, Object value) {
                switch (valueKey) {
                    case "address": {
                        MappingData md = (MappingData)value;
                        sb.append(Stringifier.getString((MappingRecord)md.getRecord(), (int)2));
                        sb.append("\n");
                        break;
                    }
                    case "subscribers": {
                        Set subscribers = (Set)value;
                        sb.append(LispMapCacheStringifier.prettyPrintSubscriberSet(subscribers, 4));
                        sb.append("\n");
                        break;
                    }
                }
            }
        };
        dao.getAll(new IRowVisitor(){
            String lastKey = "";

            public void visitRow(Object keyId, String valueKey, Object value) {
                String key = keyId.getClass().getSimpleName() + "#" + keyId;
                if (!this.lastKey.equals(key)) {
                    sb.append("Instance ID " + keyId + "\n");
                }
                if (valueKey.equals("vni")) {
                    ((ILispDAO)value).getAll(mappingVisitor);
                }
                this.lastKey = key;
            }
        });
        return sb.toString();
    }

    public static String prettyPrintSubscriberSet(Set<Subscriber> subscribers, int indentation) {
        String indent = new String(new char[indentation]).replace("\u0000", " ");
        StringBuilder sb = new StringBuilder(indent);
        sb.append("   -----------------------------------------------------------------\n");
        sb.append(indent);
        if (subscribers == null) {
            return sb.append("   No subscribers").toString();
        }
        sb.append("-> Subscriber RLOC                                 Subscriber EID\n   ");
        sb.append(indent);
        boolean first = true;
        for (Subscriber subscriber : subscribers) {
            if (first) {
                first = false;
            } else {
                sb.append("\n   ");
                sb.append(indent);
            }
            String srcRloc = LispAddressStringifier.getString((LispAddress)subscriber.getSrcRloc());
            int padLen = 48 - srcRloc.length();
            sb.append(srcRloc);
            sb.append(new String(new char[padLen]).replace("\u0000", " "));
            sb.append(LispAddressStringifier.getString((LispAddress)subscriber.getSrcEid()));
        }
        return sb.toString();
    }
}

