/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.netconf.impl;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.lispflowmapping.netconf.impl.LispNetconfConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.lispflowmapping.netconf.rev140706.BuildConnectorInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.lispflowmapping.netconf.rev140706.LfmNetconfConnectorService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.lispflowmapping.netconf.rev140706.RemoveConnectorInput;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LispDeviceNetconfConnector
implements AutoCloseable,
LfmNetconfConnectorService {
    private static final Logger LOG = LoggerFactory.getLogger(LispDeviceNetconfConnector.class);
    private final ExecutorService executor;
    private LispNetconfConnector nconfConnector;

    public static LispDeviceNetconfConnector createLispDeviceNetconfConnector() {
        return new LispDeviceNetconfConnector(Executors.newFixedThreadPool(1), new LispNetconfConnector());
    }

    public LispDeviceNetconfConnector(ExecutorService executor, LispNetconfConnector nconfConnector) {
        this.executor = executor;
        this.nconfConnector = nconfConnector;
        LOG.info("LispDeviceNetconfConnector constructed");
    }

    @Override
    public void close() throws ExecutionException, InterruptedException {
        this.executor.shutdown();
    }

    @Override
    public Future<RpcResult<Void>> buildConnector(BuildConnectorInput input) {
        SettableFuture futureResult = SettableFuture.create();
        LOG.trace("Received RPC to buildConnector: " + input);
        if (!this.verifyBuildInput(input, (SettableFuture<RpcResult<Void>>)futureResult)) {
            return futureResult;
        }
        return this.executor.submit(new MakeConnector(input));
    }

    @Override
    public Future<RpcResult<Void>> removeConnector(RemoveConnectorInput input) {
        SettableFuture futureResult = SettableFuture.create();
        if (!this.verifyRemoveInput(input, (SettableFuture<RpcResult<Void>>)futureResult)) {
            return futureResult;
        }
        return this.executor.submit(new RemoveConnector(input));
    }

    private boolean verifyBuildInput(BuildConnectorInput req, SettableFuture<RpcResult<Void>> futureResult) {
        if (req.getInstance() == null) {
            LOG.error("Instance name not initialized");
            futureResult.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "exception", "Instance name not initialized").build());
            return false;
        }
        if (req.getAddress() == null) {
            LOG.error("IP address not initialized");
            futureResult.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "exception", "IP address not initialized").build());
            return false;
        }
        if (req.getPort() == null) {
            LOG.error("Port not initialized");
            futureResult.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "exception", "Port not initialized").build());
            return false;
        }
        if (req.getUsername() == null) {
            LOG.error("Username not initialized");
            futureResult.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "exception", "Username not initialized").build());
            return false;
        }
        if (req.getPassword() == null) {
            LOG.error("Password not initialized");
            futureResult.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "exception", "Password not initialized").build());
            return false;
        }
        return true;
    }

    private boolean verifyRemoveInput(RemoveConnectorInput conn, SettableFuture<RpcResult<Void>> futureResult) {
        if (conn.getInstance() == null) {
            LOG.error("Instance name not initialized");
            futureResult.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "exception", "Instance name not initialized").build());
            return false;
        }
        return true;
    }

    private class RemoveConnector
    implements Callable<RpcResult<Void>> {
        final RemoveConnectorInput removeConnectorInput;

        public RemoveConnector(RemoveConnectorInput connectorInput) {
            this.removeConnectorInput = connectorInput;
        }

        @Override
        public RpcResult<Void> call() {
            try {
                LispDeviceNetconfConnector.this.nconfConnector.removeNetconfConnector(this.removeConnectorInput.getInstance());
                LOG.info("LispNetconfConnector {} removed!", (Object)this.removeConnectorInput.getInstance());
                return RpcResultBuilder.success().build();
            }
            catch (InstanceNotFoundException e) {
                LOG.info("LispNetconfConnector {} doesn't exists!", (Object)this.removeConnectorInput.getInstance());
                return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "no-exist", "LispNetconfConnector doesn't exist").build();
            }
            catch (ValidationException e) {
                LOG.info("LispNetconfConnector {}: Could not validate remove transactions!", (Object)this.removeConnectorInput.getInstance());
                return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "fail", "LispNetconfConnector doesn't exist").build();
            }
            catch (ConflictingVersionException e) {
                LOG.error("LispNetconfConnector {}: Cannot remove due to conflicting version", (Object)this.removeConnectorInput.getInstance());
                return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "fail", "Conflicting version exception").build();
            }
            catch (Exception e) {
                LOG.error("LispNetconfConnector {} exception while removing: {}", (Object)this.removeConnectorInput.getInstance(), e.getClass());
                return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "fail", "Cannot remove LispNetconfConnector: " + this.removeConnectorInput.getInstance()).build();
            }
        }
    }

    private class MakeConnector
    implements Callable<RpcResult<Void>> {
        final BuildConnectorInput buildConnectorInput;

        public MakeConnector(BuildConnectorInput buildConnectorInput) {
            this.buildConnectorInput = buildConnectorInput;
        }

        @Override
        public RpcResult<Void> call() {
            try {
                LispDeviceNetconfConnector.this.nconfConnector.createNetconfConnector(this.buildConnectorInput.getInstance(), this.buildConnectorInput.getAddress(), this.buildConnectorInput.getPort().getValue(), this.buildConnectorInput.getUsername(), this.buildConnectorInput.getPassword());
                LOG.info("LispNetconfConnector {} built", (Object)this.buildConnectorInput.getInstance());
                return RpcResultBuilder.success().build();
            }
            catch (InstanceAlreadyExistsException e) {
                LOG.error("LispNetconfConnector {} already exists!", (Object)this.buildConnectorInput.getInstance());
                return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "exists", "LispNetconfConnector exists").build();
            }
            catch (ConflictingVersionException ex) {
                LOG.error("LispNetconfConnector {} version exception", (Object)this.buildConnectorInput.getInstance());
                return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "exception", "LispNetconfConnector version exception").build();
            }
            catch (ValidationException ex) {
                LOG.error("LispNetconfConnector {} validation exception", (Object)this.buildConnectorInput.getInstance());
                return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "exception", "LispNetconfConnector validation exception").build();
            }
        }
    }
}

