/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.netconf.impl;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.util.ConfigRegistryJMXClient;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;
import org.opendaylight.controller.config.yang.md.sal.connector.netconf.NetconfConnectorModuleMXBean;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LispNetconfConnector {
    private ConfigRegistryJMXClient configRegistryClient;
    private static final Logger LOG = LoggerFactory.getLogger(LispNetconfConnector.class);
    private MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();

    public LispNetconfConnector() {
        this.configRegistryClient = new ConfigRegistryJMXClient(this.platformMBeanServer);
    }

    public void createNetconfConnector(String instanceName, Host host, Integer port, String username, String password) throws InstanceAlreadyExistsException, ConflictingVersionException, ValidationException {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        if (transaction == null) {
            LOG.error("Could not create transaction with ConfigRegistry! Cannot build NETCONF connector!");
            return;
        }
        ObjectName connName = transaction.createModule("sal-netconf-connector", instanceName);
        NetconfConnectorModuleMXBean mxBean = (NetconfConnectorModuleMXBean)transaction.newMXBeanProxy(connName, NetconfConnectorModuleMXBean.class);
        mxBean.setAddress(host);
        mxBean.setPassword(password);
        mxBean.setPort(new PortNumber(port));
        mxBean.setUsername(username);
        mxBean.setTcpOnly(Boolean.valueOf(false));
        if (!this.solveDependencies(transaction, mxBean)) {
            LOG.error("Failed to solve dependencies! Aborting!");
            return;
        }
        transaction.commit();
    }

    public void removeNetconfConnector(String instanceName) throws InstanceNotFoundException, ValidationException, ConflictingVersionException {
        ConfigTransactionJMXClient transaction = this.configRegistryClient.createTransaction();
        transaction.destroyModule("sal-netconf-connector", instanceName);
        transaction.commit();
    }

    private boolean solveDependencies(ConfigTransactionJMXClient transaction, NetconfConnectorModuleMXBean mxBean) {
        ObjectName bindingBrokerRegistry = this.findConfigBean("binding-broker-impl", transaction);
        if (bindingBrokerRegistry == null) {
            LOG.debug("No BindingBroker instance found");
            return false;
        }
        mxBean.setBindingRegistry(bindingBrokerRegistry);
        ObjectName domRegistry = this.findConfigBean("dom-broker-impl", transaction);
        if (domRegistry == null) {
            LOG.debug("No DomRegistryBroker instance found");
            return false;
        }
        mxBean.setDomRegistry(domRegistry);
        ObjectName eventExecutor = this.findConfigBean("netty-global-event-executor", transaction);
        if (eventExecutor == null) {
            LOG.debug("No EventExecutor instance found");
            return false;
        }
        mxBean.setEventExecutor(eventExecutor);
        ObjectName threadpool = this.findConfigBean("threadpool-flexible", transaction);
        if (threadpool == null) {
            LOG.debug("No ThreadPool instance found");
            return false;
        }
        mxBean.setProcessingExecutor(threadpool);
        ObjectName clientDispatcher = this.findConfigBean("netconf-client-dispatcher", transaction);
        if (clientDispatcher == null) {
            LOG.debug("No ClientDispatcher instance found");
            return false;
        }
        mxBean.setClientDispatcher(clientDispatcher);
        return true;
    }

    private ObjectName findConfigBean(String name, ConfigTransactionJMXClient transaction) {
        Set set = transaction.lookupConfigBeans(name);
        if (set.size() > 0) {
            return (ObjectName)set.iterator().next();
        }
        return null;
    }
}

