/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.lispflowmapping.netconf.rev140706;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.lispflowmapping.netconf.rev140706.BuildConnectorInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BuildConnectorInputBuilder
implements Builder<BuildConnectorInput> {
    private Host _address;
    private String _instance;
    private String _password;
    private PortNumber _port;
    private String _username;
    Map<Class<? extends Augmentation<BuildConnectorInput>>, Augmentation<BuildConnectorInput>> augmentation = Collections.emptyMap();

    public BuildConnectorInputBuilder() {
    }

    public BuildConnectorInputBuilder(BuildConnectorInput base) {
        AugmentationHolder casted;
        this._address = base.getAddress();
        this._instance = base.getInstance();
        this._password = base.getPassword();
        this._port = base.getPort();
        this._username = base.getUsername();
        if (base instanceof BuildConnectorInputImpl) {
            BuildConnectorInputImpl impl = (BuildConnectorInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BuildConnectorInput>>, Augmentation<BuildConnectorInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BuildConnectorInput>>, Augmentation<BuildConnectorInput>>(casted.augmentations());
        }
    }

    public Host getAddress() {
        return this._address;
    }

    public String getInstance() {
        return this._instance;
    }

    public String getPassword() {
        return this._password;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public String getUsername() {
        return this._username;
    }

    public <E extends Augmentation<BuildConnectorInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BuildConnectorInputBuilder setAddress(Host value) {
        if (value != null) {
            // empty if block
        }
        this._address = value;
        return this;
    }

    public BuildConnectorInputBuilder setInstance(String value) {
        this._instance = value;
        return this;
    }

    public BuildConnectorInputBuilder setPassword(String value) {
        this._password = value;
        return this;
    }

    private static void checkPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public BuildConnectorInputBuilder setPort(PortNumber value) {
        if (value != null) {
            BuildConnectorInputBuilder.checkPortRange(value.getValue());
        }
        this._port = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _port_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public BuildConnectorInputBuilder setUsername(String value) {
        this._username = value;
        return this;
    }

    public BuildConnectorInputBuilder addAugmentation(Class<? extends Augmentation<BuildConnectorInput>> augmentationType, Augmentation<BuildConnectorInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BuildConnectorInput>>, Augmentation<BuildConnectorInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BuildConnectorInputBuilder removeAugmentation(Class<? extends Augmentation<BuildConnectorInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BuildConnectorInput build() {
        return new BuildConnectorInputImpl(this);
    }

    private static final class BuildConnectorInputImpl
    implements BuildConnectorInput {
        private final Host _address;
        private final String _instance;
        private final String _password;
        private final PortNumber _port;
        private final String _username;
        private Map<Class<? extends Augmentation<BuildConnectorInput>>, Augmentation<BuildConnectorInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BuildConnectorInput> getImplementedInterface() {
            return BuildConnectorInput.class;
        }

        private BuildConnectorInputImpl(BuildConnectorInputBuilder base) {
            this._address = base.getAddress();
            this._instance = base.getInstance();
            this._password = base.getPassword();
            this._port = base.getPort();
            this._username = base.getUsername();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BuildConnectorInput>>, Augmentation<BuildConnectorInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BuildConnectorInput>>, Augmentation<BuildConnectorInput>>(base.augmentation);
                }
            }
        }

        @Override
        public Host getAddress() {
            return this._address;
        }

        @Override
        public String getInstance() {
            return this._instance;
        }

        @Override
        public String getPassword() {
            return this._password;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public String getUsername() {
            return this._username;
        }

        public <E extends Augmentation<BuildConnectorInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._address == null ? 0 : this._address.hashCode());
            result = 31 * result + (this._instance == null ? 0 : this._instance.hashCode());
            result = 31 * result + (this._password == null ? 0 : this._password.hashCode());
            result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
            result = 31 * result + (this._username == null ? 0 : this._username.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BuildConnectorInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BuildConnectorInput other = (BuildConnectorInput)obj;
            if (this._address == null ? other.getAddress() != null : !this._address.equals((Object)other.getAddress())) {
                return false;
            }
            if (this._instance == null ? other.getInstance() != null : !this._instance.equals(other.getInstance())) {
                return false;
            }
            if (this._password == null ? other.getPassword() != null : !this._password.equals(other.getPassword())) {
                return false;
            }
            if (this._port == null ? other.getPort() != null : !this._port.equals((Object)other.getPort())) {
                return false;
            }
            if (this._username == null ? other.getUsername() != null : !this._username.equals(other.getUsername())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BuildConnectorInputImpl otherImpl = (BuildConnectorInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BuildConnectorInput>>, Augmentation<BuildConnectorInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("BuildConnectorInput [");
            boolean first = true;
            if (this._address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_address=");
                builder.append(this._address);
            }
            if (this._instance != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_instance=");
                builder.append(this._instance);
            }
            if (this._password != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_password=");
                builder.append(this._password);
            }
            if (this._port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(this._port);
            }
            if (this._username != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_username=");
                builder.append(this._username);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

