/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.neutron;

import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.networkconfig.neutron.INeutronNetworkAware;
import org.opendaylight.controller.networkconfig.neutron.NeutronNetwork;
import org.opendaylight.lispflowmapping.interfaces.lisp.IFlowMapping;
import org.opendaylight.lispflowmapping.neutron.ILispNeutronService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LispNeutronService
implements ILispNeutronService,
INeutronNetworkAware {
    protected static final Logger logger = LoggerFactory.getLogger(LispNeutronService.class);
    private IFlowMapping mappingService;

    @Override
    public IFlowMapping getMappingService() {
        return this.mappingService;
    }

    void setFlowMappingService(IFlowMapping mappingService) {
        logger.debug("FlowMapping set in LispNeutron");
        this.mappingService = mappingService;
    }

    void unsetFlowMappingService(IFlowMapping mappingService) {
        logger.debug("LispDAO was unset in LISP Neutron");
        this.mappingService = null;
    }

    public void init() {
        logger.debug("LISP Neutron Service is initialized!");
    }

    public void start() {
        logger.info("LISP Neutron Service is up!");
        this.registerWithOSGIConsole();
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public void stop() {
        logger.info("LISP Neutron Service is down!");
    }

    public void destroy() {
        logger.debug("LISP Neutron Service is destroyed!");
        this.mappingService = null;
    }

    public int canCreateNetwork(NeutronNetwork network) {
        logger.info("hello world!");
        logger.info("canCreateNetwork called!");
        logger.info("Network name: " + network.getNetworkName());
        return 200;
    }

    public void neutronNetworkCreated(NeutronNetwork input) {
        logger.info("neutronNetworkCreated called!");
    }

    public int canUpdateNetwork(NeutronNetwork delta, NeutronNetwork original) {
        logger.info("canUpdateNetwork called!");
        if (delta.getNetworkName() != null || delta.getAdminStateUp() != null || delta.getShared() != null || delta.getRouterExternal() != null) {
            return 403;
        }
        return 200;
    }

    public void neutronNetworkUpdated(NeutronNetwork network) {
        logger.info("neutronNetworkUpdated called!");
    }

    public int canDeleteNetwork(NeutronNetwork network) {
        logger.info("canDeleteNetwork called!");
        return 200;
    }

    public void neutronNetworkDeleted(NeutronNetwork network) {
        logger.info("neutronNetworkDeleted called!");
    }
}

