package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping bridge-based-attributes {
 *   leaf bridge-domain {
 *     type bridge-domain-ref;
 *   }
 *   leaf split-horizon-group {
 *     when ../bridge-domain;
 *     type uint8 {
 *       range 0..255;
 *     }
 *     default 0;
 *   }
 *   leaf bridged-virtual-interface {
 *     when ../bridge-domain;
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/bridge-based-attributes</i>
 *
 */
public interface BridgeBasedAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("bridge-based-attributes");

    @Override
    Class<? extends BridgeBasedAttributes> implementedInterface();
    
    /**
     * Interfaces in a bridge-domain forward packets to other interfaces in the same
     * bridge-domain based on destination mac address.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>bridgeDomain</code>, or <code>null</code> if not present
     */
    @Nullable String getBridgeDomain();
    
    /**
     * Interface's split-horizon group. Interfaces in the same bridge-domain and
     * split-horizon group can not forward packets between each other. 
     *
     *
     *
     * @return <code>java.lang.Short</code> <code>splitHorizonGroup</code>, or <code>null</code> if not present
     */
    @Nullable Short getSplitHorizonGroup();
    
    /**
     * Interface forward packets in the bridge-domain associated with the BVI.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>bridgedVirtualInterface</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isBridgedVirtualInterface();

}

