package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.ArpTerminationTable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping bridge-domain-attributes {
 *   leaf flood {
 *     type boolean;
 *     default true;
 *   }
 *   leaf forward {
 *     type boolean;
 *     default true;
 *   }
 *   leaf learn {
 *     type boolean;
 *     default true;
 *   }
 *   leaf unknown-unicast-flood {
 *     type boolean;
 *     default true;
 *   }
 *   leaf arp-termination {
 *     type boolean;
 *     default false;
 *   }
 *   container arp-termination-table {
 *     when "../v3po:arp-termination = 'true'";
 *     list arp-termination-table-entry {
 *       key "ip-address phys-address";
 *       leaf ip-address {
 *         type inet:ip-address;
 *       }
 *       leaf phys-address {
 *         type yang:phys-address;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/bridge-domain-attributes</i>
 *
 */
public interface BridgeDomainAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("bridge-domain-attributes");

    @Override
    Class<? extends BridgeDomainAttributes> implementedInterface();
    
    /**
     * Enable/disable L2 flooding.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>flood</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isFlood();
    
    /**
     * Enable/disable L2 forwarding.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>forward</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isForward();
    
    /**
     * Enable/disable L2 learning.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>learn</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isLearn();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>unknownUnicastFlood</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isUnknownUnicastFlood();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>arpTermination</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isArpTermination();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.ArpTerminationTable</code> <code>arpTerminationTable</code>, or <code>null</code> if not present
     */
    @Nullable ArpTerminationTable getArpTerminationTable();

}

