package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domains.BridgeDomain;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * container bridge-domains {
 *   presence "Bridge domains configuration";
 *   list bridge-domain {
 *     key name;
 *     leaf name {
 *       type string;
 *     }
 *     uses bridge-domain-attributes;
 *     uses l2-fib-attributes;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/bridge-domains</i>
 *
 * <p>To create instances of this class use {@link BridgeDomainsBuilder}.
 * @see BridgeDomainsBuilder
 *
 */
public interface BridgeDomains
    extends
    ChildOf<V3poData>,
    Augmentable<BridgeDomains>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("bridge-domains");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomains> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomains.class;
    }
    
    /**
     * bridge-domain configuration
     *
     *
     *
     * @return <code>java.util.List</code> <code>bridgeDomain</code>, or <code>null</code> if not present
     */
    @Nullable List<BridgeDomain> getBridgeDomain();
    
    /**
     * @return <code>java.util.List</code> <code>bridgeDomain</code>, or an empty list if it is not present
     */
    default @NonNull List<BridgeDomain> nonnullBridgeDomain() {
        return CodeHelpers.nonnull(getBridgeDomain());
    }

}

