package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping ethernet-base-attributes {
 *   leaf mtu {
 *     type uint16 {
 *       range 64..9216;
 *     }
 *     units octets;
 *     default 9216;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/ethernet-base-attributes</i>
 *
 */
public interface EthernetBaseAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ethernet-base-attributes");

    @Override
    Class<? extends EthernetBaseAttributes> implementedInterface();
    
    /**
     * The size, in octets, of the largest packet that the hardware interface will send
     * and receive.
     *
     *
     *
     * @return <code>java.lang.Integer</code> <code>mtu</code>, or <code>null</code> if not present
     */
    @Nullable Integer getMtu();

}

