package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping ethernet-state-attributes {
 *   leaf manufacturer-description {
 *     type string;
 *     config false;
 *   }
 *   leaf duplex {
 *     type enumeration {
 *       enum half;
 *       enum full;
 *     }
 *     config false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/ethernet-state-attributes</i>
 *
 */
public interface EthernetStateAttributes
    extends
    DataObject
{


    public enum Duplex implements Enumeration {
        Half(0, "half"),
        
        Full(1, "full")
        ;
    
        private static final Map<String, Duplex> NAME_MAP;
        private static final Map<Integer, Duplex> VALUE_MAP;
    
        static {
            final Builder<String, Duplex> nb = ImmutableMap.builder();
            final Builder<Integer, Duplex> vb = ImmutableMap.builder();
            for (Duplex enumItem : Duplex.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private Duplex(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding Duplex item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<Duplex> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Duplex item, or null if no such item exists
         */
        public static Duplex forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ethernet-state-attributes");

    @Override
    Class<? extends EthernetStateAttributes> implementedInterface();
    
    /**
     * @return <code>java.lang.String</code> <code>manufacturerDescription</code>, or <code>null</code> if not present
     */
    @Nullable String getManufacturerDescription();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.EthernetStateAttributes.Duplex</code> <code>duplex</code>, or <code>null</code> if not present
     */
    @Nullable Duplex getDuplex();

}

