package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping gre-base-attributes {
 *   leaf src {
 *     type inet:ip-address;
 *   }
 *   leaf dst {
 *     type inet:ip-address;
 *   }
 *   leaf outer-fib-id {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/gre-base-attributes</i>
 *
 */
public interface GreBaseAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("gre-base-attributes");

    @Override
    Class<? extends GreBaseAttributes> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>src</code>, or <code>null</code> if not present
     */
    @Nullable IpAddress getSrc();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>dst</code>, or <code>null</code> if not present
     */
    @Nullable IpAddress getDst();
    
    /**
     * @return <code>java.lang.Long</code> <code>outerFibId</code>, or <code>null</code> if not present
     */
    @Nullable Long getOuterFibId();

}

