package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * notification interface-deleted {
 *   leaf name {
 *     type interface-name-or-index;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/interface-deleted</i>
 *
 * <p>To create instances of this class use {@link InterfaceDeletedBuilder}.
 * @see InterfaceDeletedBuilder
 *
 */
public interface InterfaceDeleted
    extends
    DataObject,
    Augmentable<InterfaceDeleted>,
    Notification
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("interface-deleted");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceDeleted> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceDeleted.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceNameOrIndex</code> <code>name</code>, or <code>null</code> if not present
     */
    @Nullable InterfaceNameOrIndex getName();

}

