package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class InterfaceNameOrIndex
 implements TypeObject, Serializable {
    private static final long serialVersionUID = 5023251238332270748L;
    private final String _string;
    private final Long _uint32;


    public InterfaceNameOrIndex(String _string) {
        super();
        this._string = _string;
        this._uint32 = null;
    }
    
    private static void checkUint32Range(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    public InterfaceNameOrIndex(Long _uint32) {
        super();
        checkUint32Range(_uint32);
        
        this._uint32 = _uint32;
        this._string = null;
    }
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public InterfaceNameOrIndex(InterfaceNameOrIndex source) {
        this._string = source._string;
        this._uint32 = source._uint32;
    }
    
    /**
     * Return a String representing the value of this union.
     *
     * @return String representation of this union's value.
     */
    public String stringValue() {
        if (_string != null) {
            return _string;
        }
        if (_uint32 != null) {
            return _uint32.toString();
        }
    
        throw new IllegalStateException("No value assinged");
    }


    public String getString() {
        return _string;
    }
    
    public Long getUint32() {
        return _uint32;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_string);
        result = prime * result + Objects.hashCode(_uint32);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        InterfaceNameOrIndex other = (InterfaceNameOrIndex) obj;
        if (!Objects.equals(_string, other._string)) {
            return false;
        }
        if (!Objects.equals(_uint32, other._uint32)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(InterfaceNameOrIndex.class);
        CodeHelpers.appendValue(helper, "_string", _string);
        CodeHelpers.appendValue(helper, "_uint32", _uint32);
        return helper.toString();
    }
}

