package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * notification interface-state-change {
 *   leaf name {
 *     type interface-name-or-index;
 *   }
 *   leaf admin-status {
 *     type interface-status;
 *   }
 *   leaf oper-status {
 *     type interface-status;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/interface-state-change</i>
 *
 * <p>To create instances of this class use {@link InterfaceStateChangeBuilder}.
 * @see InterfaceStateChangeBuilder
 *
 */
public interface InterfaceStateChange
    extends
    DataObject,
    Augmentable<InterfaceStateChange>,
    Notification
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("interface-state-change");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceStateChange> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceStateChange.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceNameOrIndex</code> <code>name</code>, or <code>null</code> if not present
     */
    @Nullable InterfaceNameOrIndex getName();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceStatus</code> <code>adminStatus</code>, or <code>null</code> if not present
     */
    @Nullable InterfaceStatus getAdminStatus();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.InterfaceStatus</code> <code>operStatus</code>, or <code>null</code> if not present
     */
    @Nullable InterfaceStatus getOperStatus();

}

