package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping interface-tag {
 *   leaf tag {
 *     type string {
 *       length 1..63;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/interface-tag</i>
 *
 */
public interface InterfaceTag
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("interface-tag");

    @Override
    Class<? extends InterfaceTag> implementedInterface();
    
    /**
     * ASCII string placeholder for interface metadata. Value is stored in vpp, and
     * returned in read requests. No processing involved.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>tag</code>, or <code>null</code> if not present
     */
    @Nullable String getTag();

}

