package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.L2FibTable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping l2-fib-attributes {
 *   container l2-fib-table {
 *     list l2-fib-entry {
 *       key phys-address;
 *       leaf phys-address {
 *         type yang:phys-address;
 *       }
 *       leaf outgoing-interface {
 *         when "../action != 'l2-fib-filter'";
 *         type if:interface-ref;
 *       }
 *       leaf static-config {
 *         type boolean;
 *         default false;
 *       }
 *       leaf action {
 *         type l2-fib-action;
 *       }
 *       leaf bridged-virtual-interface {
 *         when "../action = 'forward'";
 *         type boolean;
 *         config false;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/l2-fib-attributes</i>
 *
 */
public interface L2FibAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("l2-fib-attributes");

    @Override
    Class<? extends L2FibAttributes> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.fib.attributes.L2FibTable</code> <code>l2FibTable</code>, or <code>null</code> if not present
     */
    @Nullable L2FibTable getL2FibTable();

}

