package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.state.attributes.Interconnection;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Parameters for configuring Layer2 features on interfaces.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping l2-state-attributes {
 *   choice interconnection {
 *     case xconnect-based {
 *       leaf xconnect-outgoing-interface {
 *         must "../../if:name != current()";
 *         type if:interface-state-ref;
 *       }
 *     }
 *     case bridge-based {
 *       uses bridge-based-attributes;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/l2-state-attributes</i>
 *
 */
public interface L2StateAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("l2-state-attributes");

    @Override
    Class<? extends L2StateAttributes> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.l2.state.attributes.Interconnection</code> <code>interconnection</code>, or <code>null</code> if not present
     */
    @Nullable Interconnection getInterconnection();

}

