package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping loopback-interface-base-attributes {
 *   leaf mac {
 *     type yang:phys-address;
 *     mandatory false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/loopback-interface-base-attributes</i>
 *
 */
public interface LoopbackInterfaceBaseAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("loopback-interface-base-attributes");

    @Override
    Class<? extends LoopbackInterfaceBaseAttributes> implementedInterface();
    
    /**
     * Mac address of the loopback interface
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress</code> <code>mac</code>, or <code>null</code> if not present
     */
    @Nullable PhysAddress getMac();

}

