package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Defines VRF tables used for ipv4 and ipv6 traffic
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping routing-base-attributes {
 *   leaf ipv4-vrf-id {
 *     type uint32;
 *   }
 *   leaf ipv6-vrf-id {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/routing-base-attributes</i>
 *
 */
public interface RoutingBaseAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("routing-base-attributes");

    @Override
    Class<? extends RoutingBaseAttributes> implementedInterface();
    
    /**
     * @return <code>java.lang.Long</code> <code>ipv4VrfId</code>, or <code>null</code> if not present
     */
    @Nullable Long getIpv4VrfId();
    
    /**
     * @return <code>java.lang.Long</code> <code>ipv6VrfId</code>, or <code>null</code> if not present
     */
    @Nullable Long getIpv6VrfId();

}

