package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.span.state.attributes.MirroredInterfaces;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Parameters of the SPAN feature
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping span-state-attributes {
 *   container mirrored-interfaces {
 *     list mirrored-interface {
 *       key iface-ref;
 *       leaf iface-ref {
 *         type if:interface-state-ref;
 *       }
 *       leaf state {
 *         type span-state;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/span-state-attributes</i>
 *
 */
public interface SpanStateAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("span-state-attributes");

    @Override
    Class<? extends SpanStateAttributes> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.span.state.attributes.MirroredInterfaces</code> <code>mirroredInterfaces</code>, or <code>null</code> if not present
     */
    @Nullable MirroredInterfaces getMirroredInterfaces();

}

