package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping tap-interface-base-attributes {
 *   leaf tap-name {
 *     type string {
 *       pattern "[a-zA-Z0-9\-;.+@$#^&amp;*!_()=\[\]]*";
 *     }
 *   }
 *   uses interface-tag;
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/tap-interface-base-attributes</i>
 *
 */
public interface TapInterfaceBaseAttributes
    extends
    DataObject,
    InterfaceTag
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("tap-interface-base-attributes");

    @Override
    Class<? extends TapInterfaceBaseAttributes> implementedInterface();
    
    /**
     * @return <code>java.lang.String</code> <code>tapName</code>, or <code>null</code> if not present
     */
    @Nullable String getTapName();

}

