package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping tap-interface-config-attributes {
 *   leaf mac {
 *     type yang:phys-address;
 *     mandatory false;
 *   }
 *   leaf device-instance {
 *     type uint32;
 *     mandatory false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/tap-interface-config-attributes</i>
 *
 */
public interface TapInterfaceConfigAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("tap-interface-config-attributes");

    @Override
    Class<? extends TapInterfaceConfigAttributes> implementedInterface();
    
    /**
     * Mac address to be set for the tap interface. Random will be used if not
     * configured
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress</code> <code>mac</code>, or <code>null</code> if not present
     */
    @Nullable PhysAddress getMac();
    
    /**
     * Custom device instance. Autogenerated will be used if not configured
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>deviceInstance</code>, or <code>null</code> if not present
     */
    @Nullable Long getDeviceInstance();

}

