package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * module v3po {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:v3po;
 *   prefix v3po;
 *   revision 2017-06-07 {
 *   }
 *   revision 2017-03-15 {
 *   }
 *   revision 2016-12-14 {
 *   }
 *   revision 2015-01-05 {
 *   }
 *   import iana-if-type {
 *     prefix ianaift;
 *   }
 *   import ietf-interfaces {
 *     prefix if;
 *   }
 *   import ietf-yang-types {
 *     prefix yang;
 *   }
 *   import ietf-inet-types {
 *     prefix inet;
 *   }
 *   import ietf-ip {
 *     prefix ip;
 *   }
 *   import yang-ext {
 *     prefix ext;
 *   }
 *   typedef bridge-domain-ref {
 *     type leafref {
 *       path /bridge-domains/bridge-domain/name;
 *     }
 *   }
 *   typedef bridged-virtual-interface-ref {
 *     type leafref {
 *       path /if:interfaces/if:interface/l2/bridged-virtual-interface;
 *     }
 *   }
 *   identity vxlan-tunnel {
 *     base if:interface-type;
 *   }
 *   identity gre-tunnel {
 *     base if:interface-type;
 *   }
 *   identity vhost-user {
 *     base if:interface-type;
 *   }
 *   identity tap {
 *     base if:interface-type;
 *   }
 *   identity loopback {
 *     base if:interface-type;
 *   }
 *   identity l2-fib-action {
 *   }
 *   identity l2-fib-forward {
 *     base l2-fib-action;
 *   }
 *   identity l2-fib-filter {
 *     base l2-fib-action;
 *   }
 *   typedef l2-fib-action {
 *     type identityref {
 *       base l2-fib-action;
 *     }
 *   }
 *   typedef vxlan-vni {
 *     type uint32 {
 *       range 0..16777215;
 *     }
 *   }
 *   typedef vhost-user-role {
 *     type enumeration {
 *       enum server;
 *       enum client;
 *     }
 *   }
 *   identity vxlan-gpe-tunnel {
 *     base if:interface-type;
 *   }
 *   typedef vxlan-gpe-vni {
 *     type uint32 {
 *       range 0..16777215;
 *     }
 *   }
 *   typedef vxlan-gpe-next-protocol {
 *     type enumeration {
 *       enum ipv4 {
 *         value 1;
 *       }
 *       enum ipv6 {
 *         value 2;
 *       }
 *       enum ethernet {
 *         value 3;
 *       }
 *       enum nsh {
 *         value 4;
 *       }
 *     }
 *   }
 *   typedef span-state {
 *     type enumeration {
 *       enum receive {
 *         value 1;
 *       }
 *       enum transmit {
 *         value 2;
 *       }
 *       enum both {
 *         value 3;
 *       }
 *     }
 *   }
 *   grouping bridge-domain-attributes {
 *     leaf flood {
 *       type boolean;
 *       default true;
 *     }
 *     leaf forward {
 *       type boolean;
 *       default true;
 *     }
 *     leaf learn {
 *       type boolean;
 *       default true;
 *     }
 *     leaf unknown-unicast-flood {
 *       type boolean;
 *       default true;
 *     }
 *     leaf arp-termination {
 *       type boolean;
 *       default false;
 *     }
 *     container arp-termination-table {
 *       when "../v3po:arp-termination = 'true'";
 *       list arp-termination-table-entry {
 *         key "ip-address phys-address";
 *         leaf ip-address {
 *           type inet:ip-address;
 *         }
 *         leaf phys-address {
 *           type yang:phys-address;
 *         }
 *       }
 *     }
 *   }
 *   grouping l2-fib-attributes {
 *     container l2-fib-table {
 *       list l2-fib-entry {
 *         key phys-address;
 *         leaf phys-address {
 *           type yang:phys-address;
 *         }
 *         leaf outgoing-interface {
 *           when "../action != 'l2-fib-filter'";
 *           type if:interface-ref;
 *         }
 *         leaf static-config {
 *           type boolean;
 *           default false;
 *         }
 *         leaf action {
 *           type l2-fib-action;
 *         }
 *         leaf bridged-virtual-interface {
 *           when "../action = 'forward'";
 *           type boolean;
 *           config false;
 *         }
 *       }
 *     }
 *   }
 *   grouping interface-tag {
 *     leaf tag {
 *       type string {
 *         length 1..63;
 *       }
 *     }
 *   }
 *   grouping tap-interface-base-attributes {
 *     leaf tap-name {
 *       type string {
 *         pattern "[a-zA-Z0-9\-;.+@$#^&amp;*!_()=\[\]]*";
 *       }
 *     }
 *     uses interface-tag;
 *   }
 *   grouping tap-interface-config-attributes {
 *     leaf mac {
 *       type yang:phys-address;
 *       mandatory false;
 *     }
 *     leaf device-instance {
 *       type uint32;
 *       mandatory false;
 *     }
 *   }
 *   grouping loopback-interface-base-attributes {
 *     leaf mac {
 *       type yang:phys-address;
 *       mandatory false;
 *     }
 *   }
 *   grouping ethernet-base-attributes {
 *     leaf mtu {
 *       type uint16 {
 *         range 64..9216;
 *       }
 *       units octets;
 *       default 9216;
 *     }
 *   }
 *   grouping routing-base-attributes {
 *     leaf ipv4-vrf-id {
 *       type uint32;
 *     }
 *     leaf ipv6-vrf-id {
 *       type uint32;
 *     }
 *   }
 *   grouping ethernet-state-attributes {
 *     leaf manufacturer-description {
 *       type string;
 *       config false;
 *     }
 *     leaf duplex {
 *       type enumeration {
 *         enum half;
 *         enum full;
 *       }
 *       config false;
 *     }
 *   }
 *   grouping vhost-user-interface-base-attributes {
 *     leaf socket {
 *       type string {
 *         length 1..255;
 *       }
 *     }
 *     leaf role {
 *       type vhost-user-role;
 *       default server;
 *     }
 *     uses interface-tag;
 *   }
 *   grouping vhost-user-interface-config-attributes {
 *     leaf device-instance {
 *       type uint32;
 *       mandatory false;
 *     }
 *   }
 *   grouping vhost-user-interface-state-attributes {
 *     leaf features {
 *       type uint64;
 *       config false;
 *     }
 *     leaf virtio-net-hdr-size {
 *       type uint32;
 *       config false;
 *     }
 *     leaf num-memory-regions {
 *       type uint32;
 *       config false;
 *     }
 *     leaf connect-error {
 *       type string;
 *       config false;
 *     }
 *   }
 *   identity decap-node {
 *   }
 *   identity l2-input {
 *     base decap-node;
 *   }
 *   identity nsh-proxy {
 *     base decap-node;
 *   }
 *   typedef vxlan-decap-node {
 *     type identityref {
 *       base decap-node;
 *     }
 *   }
 *   grouping vxlan-base-attributes {
 *     leaf src {
 *       type inet:ip-address;
 *     }
 *     leaf dst {
 *       type inet:ip-address;
 *     }
 *     leaf vni {
 *       type vxlan-vni;
 *     }
 *     leaf encap-vrf-id {
 *       type uint32;
 *     }
 *     leaf decap-next {
 *       type vxlan-decap-node;
 *       default l2-input;
 *     }
 *   }
 *   grouping gre-base-attributes {
 *     leaf src {
 *       type inet:ip-address;
 *     }
 *     leaf dst {
 *       type inet:ip-address;
 *     }
 *     leaf outer-fib-id {
 *       type uint32;
 *     }
 *   }
 *   grouping vxlan-gpe-base-attributes {
 *     leaf local {
 *       type inet:ip-address;
 *     }
 *     leaf remote {
 *       type inet:ip-address;
 *     }
 *     leaf vni {
 *       type vxlan-gpe-vni;
 *     }
 *     leaf next-protocol {
 *       type vxlan-gpe-next-protocol;
 *     }
 *     leaf encap-vrf-id {
 *       type uint32;
 *     }
 *     leaf decap-vrf-id {
 *       type uint32;
 *     }
 *   }
 *   grouping l2-config-attributes {
 *     choice interconnection {
 *       case xconnect-based {
 *         leaf xconnect-outgoing-interface {
 *           must "../../if:name != current()";
 *           type if:interface-ref;
 *         }
 *       }
 *       case bridge-based {
 *         uses bridge-based-attributes;
 *       }
 *     }
 *   }
 *   grouping l2-state-attributes {
 *     choice interconnection {
 *       case xconnect-based {
 *         leaf xconnect-outgoing-interface {
 *           must "../../if:name != current()";
 *           type if:interface-state-ref;
 *         }
 *       }
 *       case bridge-based {
 *         uses bridge-based-attributes;
 *       }
 *     }
 *   }
 *   grouping bridge-based-attributes {
 *     leaf bridge-domain {
 *       type bridge-domain-ref;
 *     }
 *     leaf split-horizon-group {
 *       when ../bridge-domain;
 *       type uint8 {
 *         range 0..255;
 *       }
 *       default 0;
 *     }
 *     leaf bridged-virtual-interface {
 *       when ../bridge-domain;
 *       type boolean;
 *       default false;
 *     }
 *   }
 *   grouping span-attributes {
 *     container mirrored-interfaces {
 *       list mirrored-interface {
 *         key iface-ref;
 *         leaf iface-ref {
 *           type if:interface-ref;
 *         }
 *         leaf state {
 *           type span-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping span-state-attributes {
 *     container mirrored-interfaces {
 *       list mirrored-interface {
 *         key iface-ref;
 *         leaf iface-ref {
 *           type if:interface-state-ref;
 *         }
 *         leaf state {
 *           type span-state;
 *         }
 *       }
 *     }
 *   }
 *   augment /if:interfaces/if:interface {
 *     ext:augment-identifier vpp-interface-augmentation;
 *     container tap {
 *       when "../if:type = 'v3po:tap'";
 *       uses tap-interface-base-attributes;
 *       uses tap-interface-config-attributes;
 *     }
 *     container loopback {
 *       presence "Presence of this container indicates loopback nature of the interface";
 *       when "../if:type = 'v3po:loopback'";
 *       uses loopback-interface-base-attributes;
 *     }
 *     container ethernet {
 *       when "../if:type = 'ianaift:ethernetCsmacd'";
 *       uses ethernet-base-attributes;
 *     }
 *     container routing {
 *       uses routing-base-attributes;
 *     }
 *     container vhost-user {
 *       when "../if:type = 'v3po:vhost-user'";
 *       uses vhost-user-interface-base-attributes;
 *       uses vhost-user-interface-config-attributes;
 *     }
 *     container vxlan {
 *       when "../if:type = 'v3po:vxlan-tunnel'";
 *       uses vxlan-base-attributes;
 *     }
 *     container gre {
 *       when "../if:type = 'v3po:gre-tunnel'";
 *       uses gre-base-attributes;
 *     }
 *     container l2 {
 *       must "bridged-virtual-interface = 'true' or (not (../if:ipv4[if:enabled = 'true']/if:address/if:ip) and not (../if:ipv6[if:enabled = 'true']/if:address/if:ip))";
 *       uses l2-config-attributes;
 *     }
 *     container vxlan-gpe {
 *       when "../if:type = 'v3po:vxlan-gpe-tunnel'";
 *       uses vxlan-gpe-base-attributes;
 *     }
 *     container span {
 *       uses span-attributes;
 *     }
 *   }
 *   container bridge-domains {
 *     presence "Bridge domains configuration";
 *     list bridge-domain {
 *       key name;
 *       leaf name {
 *         type string;
 *       }
 *       uses bridge-domain-attributes;
 *       uses l2-fib-attributes;
 *     }
 *   }
 *   augment /if:interfaces-state/if:interface {
 *     ext:augment-identifier vpp-interface-state-augmentation;
 *     leaf description {
 *       type string;
 *     }
 *     container tap {
 *       when "../if:type = 'v3po:tap'";
 *       uses tap-interface-base-attributes;
 *     }
 *     container ethernet {
 *       when "../if:type = 'ianaift:ethernetCsmacd'";
 *       uses ethernet-base-attributes;
 *       uses ethernet-state-attributes;
 *     }
 *     container routing {
 *       uses routing-base-attributes;
 *     }
 *     container vhost-user {
 *       when "../if:type = 'v3po:vhost-user'";
 *       uses vhost-user-interface-base-attributes;
 *       uses vhost-user-interface-state-attributes;
 *     }
 *     container vxlan {
 *       when "../if:type = 'v3po:vxlan-tunnel'";
 *       uses vxlan-base-attributes;
 *     }
 *     container vxlan-gpe {
 *       when "../if:type = 'v3po:vxlan-gpe-tunnel'";
 *       uses vxlan-gpe-base-attributes;
 *     }
 *     container gre {
 *       when "../if:type = 'gre-tunnel'";
 *       uses gre-base-attributes;
 *     }
 *     container l2 {
 *       must "bridged-virtual-interface = 'true' or (not (../if:ipv4[if:enabled = 'true']/if:address/if:ip) and not (../if:ipv6[if:enabled = 'true']/if:address/if:ip))";
 *       uses l2-state-attributes;
 *     }
 *     container span {
 *       uses span-state-attributes;
 *     }
 *   }
 *   augment /if:interfaces-state/if:interface/if:statistics {
 *     ext:augment-identifier vpp-interface-statistics-augmentation;
 *     leaf in-errors-no-buf {
 *       type yang:counter64;
 *     }
 *     leaf in-errors-miss {
 *       type yang:counter64;
 *     }
 *     leaf out-discards-fifo-full {
 *       type yang:counter64;
 *     }
 *   }
 *   container bridge-domains-state {
 *     config false;
 *     list bridge-domain {
 *       key name;
 *       leaf name {
 *         type string;
 *       }
 *       uses bridge-domain-attributes;
 *       uses l2-fib-attributes;
 *     }
 *   }
 *   typedef interface-status {
 *     type enumeration {
 *       enum up {
 *         value 1;
 *       }
 *       enum down {
 *         value 0;
 *       }
 *     }
 *   }
 *   typedef interface-name-or-index {
 *     type union {
 *       type string;
 *       type uint32;
 *     }
 *   }
 *   notification interface-state-change {
 *     leaf name {
 *       type interface-name-or-index;
 *     }
 *     leaf admin-status {
 *       type interface-status;
 *     }
 *     leaf oper-status {
 *       type interface-status;
 *     }
 *   }
 *   notification interface-deleted {
 *     leaf name {
 *       type interface-name-or-index;
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface V3poData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomains</code> <code>bridgeDomains</code>, or <code>null</code> if not present
     */
    @Nullable BridgeDomains getBridgeDomains();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainsState</code> <code>bridgeDomainsState</code>, or <code>null</code> if not present
     */
    @Nullable BridgeDomainsState getBridgeDomainsState();

}

