package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for implementing the following YANG notifications defined in module <b>v3po</b>
 * <pre>
 * notification interface-deleted {
 *   leaf name {
 *     type interface-name-or-index;
 *   }
 * }
 * notification interface-state-change {
 *   leaf name {
 *     type interface-name-or-index;
 *   }
 *   leaf admin-status {
 *     type interface-status;
 *   }
 *   leaf oper-status {
 *     type interface-status;
 *   }
 * }
 * </pre>
 *
 */
public interface V3poListener
    extends
    NotificationListener
{




    void onInterfaceDeleted(InterfaceDeleted notification);
    
    void onInterfaceStateChange(InterfaceStateChange notification);

}

