package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * vhost-user settings
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping vhost-user-interface-base-attributes {
 *   leaf socket {
 *     type string {
 *       length 1..255;
 *     }
 *   }
 *   leaf role {
 *     type vhost-user-role;
 *     default server;
 *   }
 *   uses interface-tag;
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/vhost-user-interface-base-attributes</i>
 *
 */
public interface VhostUserInterfaceBaseAttributes
    extends
    DataObject,
    InterfaceTag
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vhost-user-interface-base-attributes");

    @Override
    Class<? extends VhostUserInterfaceBaseAttributes> implementedInterface();
    
    /**
     * @return <code>java.lang.String</code> <code>socket</code>, or <code>null</code> if not present
     */
    @Nullable String getSocket();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VhostUserRole</code> <code>role</code>, or <code>null</code> if not present
     */
    @Nullable VhostUserRole getRole();

}

