package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * vhost-user settings
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping vhost-user-interface-config-attributes {
 *   leaf device-instance {
 *     type uint32;
 *     mandatory false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/vhost-user-interface-config-attributes</i>
 *
 */
public interface VhostUserInterfaceConfigAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vhost-user-interface-config-attributes");

    @Override
    Class<? extends VhostUserInterfaceConfigAttributes> implementedInterface();
    
    /**
     * Custom device instance. Autogenerated will be used if not configured
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>deviceInstance</code>, or <code>null</code> if not present
     */
    @Nullable Long getDeviceInstance();

}

