package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.math.BigInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping vhost-user-interface-state-attributes {
 *   leaf features {
 *     type uint64;
 *     config false;
 *   }
 *   leaf virtio-net-hdr-size {
 *     type uint32;
 *     config false;
 *   }
 *   leaf num-memory-regions {
 *     type uint32;
 *     config false;
 *   }
 *   leaf connect-error {
 *     type string;
 *     config false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/vhost-user-interface-state-attributes</i>
 *
 */
public interface VhostUserInterfaceStateAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vhost-user-interface-state-attributes");

    @Override
    Class<? extends VhostUserInterfaceStateAttributes> implementedInterface();
    
    /**
     * @return <code>java.math.BigInteger</code> <code>features</code>, or <code>null</code> if not present
     */
    @Nullable BigInteger getFeatures();
    
    /**
     * @return <code>java.lang.Long</code> <code>virtioNetHdrSize</code>, or <code>null</code> if not present
     */
    @Nullable Long getVirtioNetHdrSize();
    
    /**
     * @return <code>java.lang.Long</code> <code>numMemoryRegions</code>, or <code>null</code> if not present
     */
    @Nullable Long getNumMemoryRegions();
    
    /**
     * @return <code>java.lang.String</code> <code>connectError</code>, or <code>null</code> if not present
     */
    @Nullable String getConnectError();

}

