package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum VhostUserRole implements Enumeration {
    Server(0, "server"),
    
    Client(1, "client")
    ;

    private static final Map<String, VhostUserRole> NAME_MAP;
    private static final Map<Integer, VhostUserRole> VALUE_MAP;

    static {
        final Builder<String, VhostUserRole> nb = ImmutableMap.builder();
        final Builder<Integer, VhostUserRole> vb = ImmutableMap.builder();
        for (VhostUserRole enumItem : VhostUserRole.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private VhostUserRole(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding VhostUserRole item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<VhostUserRole> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding VhostUserRole item, or null if no such item exists
     */
    public static VhostUserRole forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
