package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping vxlan-base-attributes {
 *   leaf src {
 *     type inet:ip-address;
 *   }
 *   leaf dst {
 *     type inet:ip-address;
 *   }
 *   leaf vni {
 *     type vxlan-vni;
 *   }
 *   leaf encap-vrf-id {
 *     type uint32;
 *   }
 *   leaf decap-next {
 *     type vxlan-decap-node;
 *     default l2-input;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/vxlan-base-attributes</i>
 *
 */
public interface VxlanBaseAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vxlan-base-attributes");

    @Override
    Class<? extends VxlanBaseAttributes> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>src</code>, or <code>null</code> if not present
     */
    @Nullable IpAddress getSrc();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>dst</code>, or <code>null</code> if not present
     */
    @Nullable IpAddress getDst();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanVni</code> <code>vni</code>, or <code>null</code> if not present
     */
    @Nullable VxlanVni getVni();
    
    /**
     * @return <code>java.lang.Long</code> <code>encapVrfId</code>, or <code>null</code> if not present
     */
    @Nullable Long getEncapVrfId();
    
    /**
     * @return <code>java.lang.Class</code> <code>decapNext</code>, or <code>null</code> if not present
     */
    @Nullable Class<? extends DecapNode> getDecapNext();

}

