package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * grouping vxlan-gpe-base-attributes {
 *   leaf local {
 *     type inet:ip-address;
 *   }
 *   leaf remote {
 *     type inet:ip-address;
 *   }
 *   leaf vni {
 *     type vxlan-gpe-vni;
 *   }
 *   leaf next-protocol {
 *     type vxlan-gpe-next-protocol;
 *   }
 *   leaf encap-vrf-id {
 *     type uint32;
 *   }
 *   leaf decap-vrf-id {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/vxlan-gpe-base-attributes</i>
 *
 */
public interface VxlanGpeBaseAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vxlan-gpe-base-attributes");

    @Override
    Class<? extends VxlanGpeBaseAttributes> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>local</code>, or <code>null</code> if not present
     */
    @Nullable IpAddress getLocal();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>remote</code>, or <code>null</code> if not present
     */
    @Nullable IpAddress getRemote();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeVni</code> <code>vni</code>, or <code>null</code> if not present
     */
    @Nullable VxlanGpeVni getVni();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.VxlanGpeNextProtocol</code> <code>nextProtocol</code>, or <code>null</code> if not present
     */
    @Nullable VxlanGpeNextProtocol getNextProtocol();
    
    /**
     * @return <code>java.lang.Long</code> <code>encapVrfId</code>, or <code>null</code> if not present
     */
    @Nullable Long getEncapVrfId();
    
    /**
     * @return <code>java.lang.Long</code> <code>decapVrfId</code>, or <code>null</code> if not present
     */
    @Nullable Long getDecapVrfId();

}

