package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum VxlanGpeNextProtocol implements Enumeration {
    Ipv4(1, "ipv4"),
    
    Ipv6(2, "ipv6"),
    
    Ethernet(3, "ethernet"),
    
    Nsh(4, "nsh")
    ;

    private static final Map<String, VxlanGpeNextProtocol> NAME_MAP;
    private static final Map<Integer, VxlanGpeNextProtocol> VALUE_MAP;

    static {
        final Builder<String, VxlanGpeNextProtocol> nb = ImmutableMap.builder();
        final Builder<Integer, VxlanGpeNextProtocol> vb = ImmutableMap.builder();
        for (VxlanGpeNextProtocol enumItem : VxlanGpeNextProtocol.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private VxlanGpeNextProtocol(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding VxlanGpeNextProtocol item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<VxlanGpeNextProtocol> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding VxlanGpeNextProtocol item, or null if no such item exists
     */
    public static VxlanGpeNextProtocol forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
