package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class VxlanGpeVni
 implements TypeObject, Serializable {
    private static final long serialVersionUID = -726877393663281824L;
    private final Long _value;

    private static void check_valueRange(final long value) {
        if (value >= 0L && value <= 16777215L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..16777215]]", value);
    }

    @ConstructorProperties("value")
    public VxlanGpeVni(Long _value) {
        if (_value != null) {
            check_valueRange(_value);
        }
    
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public VxlanGpeVni(VxlanGpeVni source) {
        this._value = source._value;
    }

    public static VxlanGpeVni getDefaultInstance(String defaultValue) {
        return new VxlanGpeVni(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        VxlanGpeVni other = (VxlanGpeVni) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(VxlanGpeVni.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        return helper.toString();
    }
}

