package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.arp.termination.table.ArpTerminationTableEntry;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * container arp-termination-table {
 *   when "../v3po:arp-termination = 'true'";
 *   list arp-termination-table-entry {
 *     key "ip-address phys-address";
 *     leaf ip-address {
 *       type inet:ip-address;
 *     }
 *     leaf phys-address {
 *       type yang:phys-address;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/bridge-domain-attributes/arp-termination-table</i>
 *
 * <p>To create instances of this class use {@link ArpTerminationTableBuilder}.
 * @see ArpTerminationTableBuilder
 *
 */
public interface ArpTerminationTable
    extends
    ChildOf<BridgeDomainAttributes>,
    Augmentable<ArpTerminationTable>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("arp-termination-table");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.ArpTerminationTable> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.ArpTerminationTable.class;
    }
    
    /**
     * @return <code>java.util.List</code> <code>arpTerminationTableEntry</code>, or <code>null</code> if not present
     */
    @Nullable List<ArpTerminationTableEntry> getArpTerminationTableEntry();
    
    /**
     * @return <code>java.util.List</code> <code>arpTerminationTableEntry</code>, or an empty list if it is not present
     */
    default @NonNull List<ArpTerminationTableEntry> nonnullArpTerminationTableEntry() {
        return CodeHelpers.nonnull(getArpTerminationTableEntry());
    }

}

