package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.arp.termination.table;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.ArpTerminationTable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * list arp-termination-table-entry {
 *   key "ip-address phys-address";
 *   leaf ip-address {
 *     type inet:ip-address;
 *   }
 *   leaf phys-address {
 *     type yang:phys-address;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/bridge-domain-attributes/arp-termination-table/arp-termination-table-entry</i>
 *
 * <p>To create instances of this class use {@link ArpTerminationTableEntryBuilder}.
 * @see ArpTerminationTableEntryBuilder
 * @see ArpTerminationTableEntryKey
 *
 */
public interface ArpTerminationTableEntry
    extends
    ChildOf<ArpTerminationTable>,
    Augmentable<ArpTerminationTableEntry>,
    Identifiable<ArpTerminationTableEntryKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("arp-termination-table-entry");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.arp.termination.table.ArpTerminationTableEntry> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.arp.termination.table.ArpTerminationTableEntry.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>ipAddress</code>, or <code>null</code> if not present
     */
    @Nullable IpAddress getIpAddress();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress</code> <code>physAddress</code>, or <code>null</code> if not present
     */
    @Nullable PhysAddress getPhysAddress();
    
    @Override
    ArpTerminationTableEntryKey key();

}

