package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domain.attributes.arp.termination.table;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

public class ArpTerminationTableEntryKey
 implements Identifier<ArpTerminationTableEntry> {
    private static final long serialVersionUID = -2586950980557284570L;
    private final IpAddress _ipAddress;
    private final PhysAddress _physAddress;


    public ArpTerminationTableEntryKey(IpAddress _ipAddress, PhysAddress _physAddress) {
    
    
        this._ipAddress = _ipAddress;
        this._physAddress = _physAddress;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ArpTerminationTableEntryKey(ArpTerminationTableEntryKey source) {
        this._ipAddress = source._ipAddress;
        this._physAddress = source._physAddress;
    }


    public IpAddress getIpAddress() {
        return _ipAddress;
    }
    
    public PhysAddress getPhysAddress() {
        return _physAddress;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_ipAddress);
        result = prime * result + Objects.hashCode(_physAddress);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        ArpTerminationTableEntryKey other = (ArpTerminationTableEntryKey) obj;
        if (!Objects.equals(_ipAddress, other._ipAddress)) {
            return false;
        }
        if (!Objects.equals(_physAddress, other._physAddress)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(ArpTerminationTableEntryKey.class);
        CodeHelpers.appendValue(helper, "_ipAddress", _ipAddress);
        CodeHelpers.appendValue(helper, "_physAddress", _physAddress);
        return helper.toString();
    }
}

