package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domains;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomainAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.BridgeDomains;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.L2FibAttributes;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * bridge-domain configuration
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>v3po</b>
 * <pre>
 * list bridge-domain {
 *   key name;
 *   leaf name {
 *     type string;
 *   }
 *   uses bridge-domain-attributes;
 *   uses l2-fib-attributes;
 * }
 * </pre>The schema path to identify an instance is
 * <i>v3po/bridge-domains/bridge-domain</i>
 *
 * <p>To create instances of this class use {@link BridgeDomainBuilder}.
 * @see BridgeDomainBuilder
 * @see BridgeDomainKey
 *
 */
public interface BridgeDomain
    extends
    ChildOf<BridgeDomains>,
    Augmentable<BridgeDomain>,
    BridgeDomainAttributes,
    L2FibAttributes,
    Identifiable<BridgeDomainKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("bridge-domain");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domains.BridgeDomain> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.v3po.rev170607.bridge.domains.BridgeDomain.class;
    }
    
    /**
     * @return <code>java.lang.String</code> <code>name</code>, or <code>null</code> if not present
     */
    @Nullable String getName();
    
    @Override
    BridgeDomainKey key();

}

